/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.crud;

import java.util.ArrayList;
import java.util.function.Function;
import leap.lang.Strings;
import leap.orm.dao.Dao;
import leap.web.Request;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.orm.ExpandError;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelQueryExecutor;
import leap.web.api.orm.QueryOneResult;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.restd.CrudOperation;
import leap.web.api.restd.CrudOperationBase;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.exception.NotFoundException;
import leap.web.route.RouteBuilder;

public class FindOperation
extends CrudOperationBase
implements CrudOperation {
    protected static final String NAME = "find";

    @Override
    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model) {
        if (!context.getConfig().allowFindModel(model.getName())) {
            return;
        }
        String path = this.fullModelPath(c, model) + this.getIdPath(model);
        String name = Strings.lowerCamel((String[])new String[]{NAME, model.getName()});
        this.createCrudOperation(c, context, model, path, name, null);
    }

    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model, String path, String name, CrudOperationBase.Callback callback) {
        FuncActionBuilder action = new FuncActionBuilder(name);
        RouteBuilder route = this.rm.createRoute("GET", path);
        if (null != callback) {
            callback.preAddArguments(action);
        }
        action.setFunction(this.createFunction(context, model, action.getArguments().size()));
        this.addIdArguments(context, action, model);
        this.addArgument(context, action, QueryOptionsBase.class, "options");
        if (null != callback) {
            callback.postAddArguments(action);
        }
        this.addModelResponse(action, model);
        this.preConfigure(context, model, action);
        route.setAction((Action)action.build());
        this.setCrudOperation(route, NAME);
        this.postConfigure(context, model, route);
        if (this.isOperationExists(context, route)) {
            return;
        }
        c.addDynamicRoute(this.rm.loadRoute(context.getRoutes(), route));
    }

    protected Function<ActionParams, Object> createFunction(RestdContext context, RestdModel model, int start) {
        return new FindFunction(context.getApi(), context.getDao(), model, start);
    }

    protected class FindFunction
    extends CrudOperationBase.CrudFunction {
        public FindFunction(Api api, Dao dao, RestdModel model, int start) {
            super(api, dao, model, start);
        }

        @Override
        public Object apply(ActionParams params) {
            ApiResponse response;
            boolean hasExpandErrors;
            QueryOptionsBase options;
            Object id;
            MApiModel am = this.am();
            Request request = params.getContext().getRequest();
            SimpleModelExecutorContext context = new SimpleModelExecutorContext(this.api, this.dao, am, this.em, params);
            ModelQueryExecutor executor = this.newQueryExecutor(context);
            QueryOneResult result = executor.queryOne(id = this.id(params), options = (QueryOptionsBase)this.getWithId(params, 0));
            boolean bl = hasExpandErrors = null != result.getExpandErrors() && !result.getExpandErrors().isEmpty();
            if (hasExpandErrors && !this.allowExpandErrors(request)) {
                return ApiResponse.err(request.getMessageSource().getMessage("webapi.errors.query_expand_error", new Object[0]));
            }
            if (null != result.getEntity()) {
                response = ApiResponse.of(result.getEntity());
            } else {
                if (result.getRecord() == null) {
                    throw new NotFoundException(am.getName() + " '" + id.toString() + "' not found");
                }
                response = ApiResponse.of(result.getRecord());
            }
            if (hasExpandErrors) {
                ArrayList<String> expands = new ArrayList<String>();
                for (ExpandError ee : result.getExpandErrors()) {
                    expands.add(ee.getExpand());
                }
                response.withHeader("x-err-expands", Strings.join(expands, (char)','));
            }
            return response;
        }

        protected ModelQueryExecutor newQueryExecutor(ModelExecutorContext context) {
            return FindOperation.this.mef.newQueryExecutor(context);
        }

        protected boolean allowExpandErrors(Request request) {
            return "1".equals(request.getHeader("x-allow-expand-err"));
        }

        public String toString() {
            return "Function:Find " + this.model.getName() + "";
        }
    }
}

