/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.crud;

import java.util.function.Function;
import leap.lang.Strings;
import leap.lang.convert.Converts;
import leap.orm.dao.Dao;
import leap.web.Request;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.mvc.params.DeleteOptions;
import leap.web.api.orm.DeleteOneResult;
import leap.web.api.orm.ModelDeleteExecutor;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.restd.CrudOperation;
import leap.web.api.restd.CrudOperationBase;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.exception.BadRequestException;
import leap.web.exception.NotFoundException;
import leap.web.route.RouteBuilder;

public class DeleteOperation
extends CrudOperationBase
implements CrudOperation {
    protected static final String NAME = "delete";

    @Override
    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model) {
        if (!context.getConfig().allowDeleteModel(model.getName())) {
            return;
        }
        String path = this.fullModelPath(c, model) + this.getIdPath(model);
        String name = Strings.lowerCamel((String[])new String[]{NAME, model.getName()});
        this.createCrudOperation(c, context, model, path, name, null);
    }

    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model, String path, String name, CrudOperationBase.Callback callback) {
        FuncActionBuilder action = new FuncActionBuilder(name);
        RouteBuilder route = this.rm.createRoute("DELETE", path);
        if (null != callback) {
            callback.preAddArguments(action);
        }
        action.setFunction(this.createFunction(context, model, action.getArguments().size()));
        this.addIdArguments(context, action, model);
        this.addOtherArguments(c, context, action, model);
        if (null != callback) {
            callback.postAddArguments(action);
        }
        this.addNoContentResponse(action, model);
        this.preConfigure(context, model, action);
        route.setAction((Action)action.build());
        this.setCrudOperation(route, NAME);
        this.postConfigure(context, model, route);
        if (this.isOperationExists(context, route)) {
            return;
        }
        c.addDynamicRoute(this.rm.loadRoute(context.getRoutes(), route));
    }

    protected void addOtherArguments(ApiConfigurator c, RestdContext context, FuncActionBuilder action, RestdModel model) {
        this.addArgument(context, action, DeleteOptions.class, "options");
    }

    protected Function<ActionParams, Object> createFunction(RestdContext context, RestdModel model, int start) {
        return new DeleteFunction(context.getApi(), context.getDao(), model, start, true);
    }

    protected class DeleteFunction
    extends CrudOperationBase.CrudFunction {
        private final boolean cascadeDelete;

        public DeleteFunction(Api api, Dao dao, RestdModel model, int start, boolean cascadeDelete) {
            super(api, dao, model, start);
            this.cascadeDelete = cascadeDelete;
        }

        @Override
        public Object apply(ActionParams params) {
            Request request;
            String param;
            DeleteOptions options;
            MApiModel am = this.api.getMetadata().getModel(this.model.getName());
            SimpleModelExecutorContext context = new SimpleModelExecutorContext(this.api, this.dao, am, this.em, params);
            ModelDeleteExecutor executor = this.newDeleteExecutor(context);
            Object id = this.id(params);
            DeleteOptions deleteOptions = options = this.cascadeDelete ? (DeleteOptions)this.getWithId(params, 0) : null;
            if (!this.cascadeDelete && !Strings.isEmpty((String)(param = (request = Request.tryGetCurrent()).getParameter("cascade_delete"))) && Converts.toBoolean((Object)param)) {
                throw new BadRequestException("Cascade delete not supported by this operation, check parameter 'cascade_delete'!");
            }
            DeleteOneResult result = executor.deleteOne(id, options);
            if (null != result.entity) {
                return ApiResponse.of(result.entity);
            }
            if (result.success) {
                return ApiResponse.NO_CONTENT;
            }
            throw new NotFoundException(am.getName() + " '" + id.toString() + "' not found");
        }

        protected ModelDeleteExecutor newDeleteExecutor(ModelExecutorContext context) {
            return DeleteOperation.this.mef.newDeleteExecutor(context);
        }

        public String toString() {
            return "Function:Delete " + this.model.getName() + "";
        }
    }
}

