/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.crud;

import java.util.Map;
import java.util.function.Function;
import leap.lang.Strings;
import leap.orm.dao.Dao;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.orm.CreateOneResult;
import leap.web.api.orm.ModelCreateExecutor;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.restd.CrudOperation;
import leap.web.api.restd.CrudOperationBase;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.route.RouteBuilder;

public class CreateOperation
extends CrudOperationBase
implements CrudOperation {
    protected static final String NAME = "create";

    @Override
    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model) {
        if (!context.getConfig().allowCreateModel(model.getName())) {
            return;
        }
        String path = this.fullModelPath(c, model);
        String name = Strings.lowerCamel((String[])new String[]{NAME, model.getName()});
        this.createCrudOperation(c, context, model, path, name, null);
    }

    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model, String path, String name, CrudOperationBase.Callback callback) {
        FuncActionBuilder action = new FuncActionBuilder(name);
        RouteBuilder route = this.rm.createRoute("POST", path);
        if (null != callback) {
            callback.preAddArguments(action);
        }
        action.setFunction(this.createFunction(context, model, action.getArguments().size()));
        this.addModelArgumentForCreate(context, action, model);
        if (null != callback) {
            callback.postAddArguments(action);
        }
        this.addModelResponse(action, model).setStatus(201);
        this.preConfigure(context, model, action);
        route.setAction((Action)action.build());
        this.setCrudOperation(route, NAME);
        this.postConfigure(context, model, route);
        if (this.isOperationExists(context, route)) {
            return;
        }
        c.addDynamicRoute(this.rm.loadRoute(context.getRoutes(), route));
    }

    protected Function<ActionParams, Object> createFunction(RestdContext context, RestdModel model, int start) {
        return new CreateFunction(context.getApi(), context.getDao(), model, start);
    }

    protected class CreateFunction
    extends CrudOperationBase.CrudFunction {
        public CreateFunction(Api api, Dao dao, RestdModel model, int start) {
            super(api, dao, model, start);
        }

        @Override
        public Object apply(ActionParams params) {
            MApiModel am = this.api.getMetadata().getModel(this.model.getName());
            Map record = (Map)this.getWithoutId(params, 0);
            SimpleModelExecutorContext context = new SimpleModelExecutorContext(this.api, this.dao, am, this.em, params);
            ModelCreateExecutor executor = this.newCreateExecutor(context);
            CreateOneResult result = executor.createOne(record);
            return ApiResponse.created(result.entity);
        }

        protected ModelCreateExecutor newCreateExecutor(ModelExecutorContext context) {
            return CreateOperation.this.mef.newCreateExecutor(context);
        }

        public String toString() {
            return "Function:Create " + this.model.getName() + "";
        }
    }
}

