/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd.crud;

import java.util.function.Function;
import leap.lang.Strings;
import leap.orm.dao.Dao;
import leap.web.action.Action;
import leap.web.action.ActionParams;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.mvc.params.CountOptions;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelQueryExecutor;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.restd.CrudOperation;
import leap.web.api.restd.CrudOperationBase;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.route.RouteBuilder;

public class CountOperation
extends CrudOperationBase
implements CrudOperation {
    protected static final String NAME = "count";

    @Override
    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model) {
        if (!context.getConfig().allowCountModel(model.getName())) {
            return;
        }
        String path = this.fullModelPath(c, model) + "/count";
        String name = Strings.lowerCamel((String[])new String[]{NAME, model.getName()});
        this.createCrudOperation(c, context, model, path, name, null);
    }

    public void createCrudOperation(ApiConfigurator c, RestdContext context, RestdModel model, String path, String name, CrudOperationBase.Callback callback) {
        FuncActionBuilder action = new FuncActionBuilder(name);
        RouteBuilder route = this.rm.createRoute("GET", path);
        if (null != callback) {
            callback.preAddArguments(action);
        }
        action.setFunction(this.createFunction(context, model, action.getArguments().size()));
        this.addArgument(context, action, CountOptions.class, "options");
        if (null != callback) {
            callback.postAddArguments(action);
        }
        this.addModelCountResponse(action, model);
        this.preConfigure(context, model, action);
        route.setAction((Action)action.build());
        this.setCrudOperation(route, NAME);
        this.postConfigure(context, model, route);
        if (this.isOperationExists(context, route)) {
            return;
        }
        c.addDynamicRoute(this.rm.loadRoute(context.getRoutes(), route));
    }

    protected Function<ActionParams, Object> createFunction(RestdContext context, RestdModel model, int start) {
        return new CountFunction(context.getApi(), context.getDao(), model, start);
    }

    protected class CountFunction
    extends CrudOperationBase.CrudFunction {
        public CountFunction(Api api, Dao dao, RestdModel model, int start) {
            super(api, dao, model, start);
        }

        @Override
        public Object apply(ActionParams params) {
            MApiModel am = this.am();
            SimpleModelExecutorContext context = new SimpleModelExecutorContext(this.api, this.dao, am, this.em, params);
            ModelQueryExecutor executor = this.newQueryExecutor(context);
            CountOptions options = (CountOptions)this.getWithoutId(params, 0);
            QueryListResult result = executor.count(options, null);
            return ApiResponse.of(result.getCount());
        }

        protected ModelQueryExecutor newQueryExecutor(ModelExecutorContext context) {
            return CountOperation.this.mef.newQueryExecutor(context);
        }

        public String toString() {
            return "Function:Count " + this.model.getName() + "";
        }
    }
}

