/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd;

import java.lang.reflect.Array;
import java.util.Map;
import leap.core.annotation.Inject;
import leap.core.validation.ValidationManager;
import leap.lang.Classes;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.json.JsonSettings;
import leap.lang.meta.MType;
import leap.lang.path.Paths;
import leap.orm.mapping.EntityMapping;
import leap.web.action.Argument;
import leap.web.action.ArgumentBuilder;
import leap.web.action.FailureHandler;
import leap.web.action.FuncActionBuilder;
import leap.web.annotation.NonParam;
import leap.web.annotation.ParamsWrapper;
import leap.web.api.Apis;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.meta.model.MApiOperationBuilder;
import leap.web.api.meta.model.MApiParameter;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiTag;
import leap.web.api.restd.RestdArgumentSupport;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.api.restd.RestdOperationSupport;
import leap.web.api.route.ApiRoute;
import leap.web.format.RequestFormat;
import leap.web.format.ResponseFormat;
import leap.web.route.Route;
import leap.web.route.RouteBuilder;
import leap.web.route.RouteManager;

public abstract class RestdOperationBase {
    @Inject
    protected RouteManager rm;
    @Inject
    protected Apis apis;
    @Inject
    protected ValidationManager validationManager;
    @Inject
    protected RestdOperationSupport[] operationSupports;
    @Inject
    protected RestdArgumentSupport[] argumentSupports;
    @Inject
    protected RequestFormat[] supportedConsumes;
    @Inject
    protected ResponseFormat[] supportedProduces;
    @Inject(name="api")
    protected JsonSettings apiJsonSettings;

    protected boolean isOperationExists(RestdContext context, RouteBuilder route) {
        for (ApiRoute ar : context.getApiConfig().getApiRoutes()) {
            Route route1 = ar.getRoute();
            if (!route.getMethod().equalsIgnoreCase(route1.getMethod()) || !route.getPathTemplate().getTemplate().equals(route1.getPathTemplate().getTemplate())) continue;
            route.setAction(route1.getAction());
            route.setEnabled(Boolean.valueOf(false));
            return true;
        }
        for (RestdOperationSupport support : this.operationSupports) {
            if (!support.isOperationExists(context, route)) continue;
            if (null == route.getEnabled()) {
                route.setEnabled(Boolean.valueOf(false));
            }
            return route.isDisabledExplicitly();
        }
        return false;
    }

    protected String fullModelPath(ApiConfigurator api, RestdModel model) {
        String basePath = api.config().getBasePath();
        return basePath.equals("/") ? model.getPath() : basePath + model.getPath();
    }

    protected String fullModelPath(ApiConfigurator api, RestdModel model, String path) {
        String modelPath = this.fullModelPath(api, model);
        return Paths.suffixWithoutSlash((String)modelPath) + path;
    }

    protected String fullPath(ApiConfigurator api, String path) {
        String basePath = api.config().getBasePath();
        return basePath.equals("/") ? path : basePath + path;
    }

    protected ArgumentBuilder addArgument(RestdContext context, FuncActionBuilder action, Class<?> type, String name) {
        return this.addArgument(context, action, type, name, null);
    }

    protected ArgumentBuilder addArgument(RestdContext context, FuncActionBuilder action, Class<?> type, String name, Boolean required) {
        ArgumentBuilder a = new ArgumentBuilder();
        a.setName(name);
        a.setType(type);
        a.setRequired(required);
        if (Classes.isAnnotationPresent(type, ParamsWrapper.class)) {
            BeanType bt = BeanType.of(type);
            BeanProperty[] beanPropertyArray = bt.getProperties();
            int n = beanPropertyArray.length;
            for (int i = 0; i < n; ++i) {
                BeanProperty bp = beanPropertyArray[i];
                if (!bp.isField() || bp.isAnnotationPresent(NonParam.class)) continue;
                ArgumentBuilder wrapped = new ArgumentBuilder(this.validationManager, bp);
                a.addWrappedArgument(wrapped);
            }
        }
        for (RestdArgumentSupport vs : this.argumentSupports) {
            vs.processArgument(context, a);
        }
        action.addArgument(a);
        return a;
    }

    protected void preConfigure(RestdContext context, RestdModel model, FuncActionBuilder action) {
        RestdConfig.Model m = context.getConfig().getModel(model.getName());
        if (null != m && !Strings.isEmpty((String)m.getTitle())) {
            action.setExtension((Object)new MApiTag[]{new MApiTag(model.getName(), m.getTitle())});
        } else {
            action.setExtension((Object)new MApiTag[]{new MApiTag(model.getName())});
        }
    }

    protected void postConfigure(RestdContext context, RestdModel model, RouteBuilder route) {
        route.setCsrfEnabled(Boolean.valueOf(false));
        route.setExtension(EntityMapping.class, (Object)model.getEntityMapping());
        this.postConfigure(context, model, route, null);
    }

    protected void preConfigure(RestdContext context, RouteBuilder route, FuncActionBuilder action, MApiOperationBuilder mo) {
        if (null == mo) {
            return;
        }
        block0: for (String consume : mo.getConsumes()) {
            for (RequestFormat requestFormat : this.supportedConsumes) {
                if (null == requestFormat.getPrimaryMimeType() || !requestFormat.getPrimaryMimeType().getMediaType().equalsIgnoreCase(consume)) continue;
                action.addConsume(requestFormat);
                continue block0;
            }
        }
        block2: for (String produce : mo.getProduces()) {
            for (RequestFormat requestFormat : this.supportedProduces) {
                if (null == requestFormat.getPrimaryMimeType() || !requestFormat.getPrimaryMimeType().getMediaType().equalsIgnoreCase(produce)) continue;
                action.addProduce((ResponseFormat)requestFormat);
                continue block2;
            }
        }
    }

    protected void postConfigure(RestdContext context, RestdModel model, RouteBuilder route, MApiOperationBuilder mo) {
        RestdConfig c = context.getConfig();
        if (null != model && c.isModelAnonymous(model.getName())) {
            route.setAllowAnonymous(Boolean.valueOf(true));
        }
        route.addFailureHandler((FailureHandler)context.getApiConfig().getFailureHandler());
        JsonSettings settings = this.apiJsonSettings;
        if (null == settings) {
            settings = new JsonSettings.Builder().setDateTimeFormatter("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "GMT").build();
        }
        route.setExtension((Object)settings);
        if (null != mo) {
            if (mo.isAllowAnonymous()) {
                route.setAllowAnonymous(Boolean.valueOf(true));
            }
            if (mo.isAllowClientOnly()) {
                route.setAllowClientOnly(Boolean.valueOf(true));
            }
            route.setPermissions(mo.getPermissions());
            route.setSecurities(mo.getSecurities());
        }
    }

    protected void createArguments(RouteBuilder route, FuncActionBuilder action, MApiOperationBuilder mo) {
        for (MApiParameterBuilder p : mo.getParameters()) {
            this.addArgument(route, action, p);
        }
    }

    protected void addArgument(RouteBuilder route, FuncActionBuilder action, MApiParameterBuilder p) {
        ArgumentBuilder arg = new ArgumentBuilder();
        arg.setName(p.getName());
        arg.setRequired(p.getRequired());
        if (null != p.getValidators() && !p.getValidators().isEmpty()) {
            p.getValidators().forEach(arg_0 -> ((ArgumentBuilder)arg).addValidator(arg_0));
        }
        this.resolveArgumentType(route, p, arg);
        this.resolveArgumentLocation(route, p, arg);
        action.addArgument(arg);
    }

    protected void resolveArgumentType(RouteBuilder route, MApiParameterBuilder p, ArgumentBuilder arg) {
        MType type = p.getType();
        if (type.isComplexType() || type.isTypeRef()) {
            arg.setType(Map.class);
            return;
        }
        if (type.isSimpleType()) {
            arg.setType(type.asSimpleType().getJavaType());
            return;
        }
        if (type.isObjectType()) {
            arg.setType(Object.class);
            return;
        }
        if (type.isDictionaryType()) {
            arg.setType(Map.class);
            return;
        }
        if (type.isCollectionType()) {
            MType elementType = type.asCollectionType().getElementType();
            if (elementType.isSimpleType()) {
                arg.setType(Array.newInstance(elementType.asSimpleType().getJavaType(), 0).getClass());
            } else if (elementType.isObjectType()) {
                arg.setType(Object[].class);
            } else {
                arg.setType(Map[].class);
            }
            return;
        }
        throw new IllegalStateException("Unsupported type '" + type + "' at parameter '" + p.getName() + "'");
    }

    protected void resolveArgumentLocation(RouteBuilder route, MApiParameterBuilder p, ArgumentBuilder arg) {
        this.setDefaultLocation(route, p);
        if (p.getLocation() == MApiParameter.Location.BODY) {
            arg.setLocation(Argument.Location.REQUEST_BODY);
            return;
        }
        if (p.getLocation() == MApiParameter.Location.QUERY) {
            arg.setLocation(Argument.Location.QUERY_PARAM);
            return;
        }
        if (p.getLocation() == MApiParameter.Location.FORM) {
            arg.setLocation(Argument.Location.REQUEST_PARAM);
            return;
        }
        if (p.getLocation() == MApiParameter.Location.PATH) {
            arg.setLocation(Argument.Location.PATH_PARAM);
            return;
        }
        if (p.getLocation() == MApiParameter.Location.HEADER) {
            arg.setLocation(Argument.Location.HEADER_PARAM);
            return;
        }
        throw new IllegalStateException("Location '" + (Object)((Object)p.getLocation()) + "' not implemented!");
    }

    protected boolean setDefaultLocation(RouteBuilder route, MApiParameterBuilder p) {
        if (null == p.getLocation()) {
            if (route.getPathTemplate().getTemplateVariables().contains(p.getName())) {
                p.setLocation(MApiParameter.Location.PATH);
                return true;
            }
            if (p.getType().isComplexType() || p.getType().isTypeRef() || p.getType().isDictionaryType()) {
                p.setLocation(MApiParameter.Location.BODY);
                return true;
            }
            p.setLocation(MApiParameter.Location.QUERY);
            return true;
        }
        return false;
    }
}

