/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import leap.core.annotation.Inject;
import leap.core.meta.MTypeContainer;
import leap.lang.Strings;
import leap.lang.meta.MComplexType;
import leap.lang.path.AntPathPattern;
import leap.orm.OrmContext;
import leap.orm.OrmMetadata;
import leap.orm.OrmRegistry;
import leap.orm.dao.Dao;
import leap.orm.mapping.EntityMapping;
import leap.orm.metadata.OrmMTypeFactory;
import leap.web.App;
import leap.web.api.Api;
import leap.web.api.config.ApiConfigException;
import leap.web.api.config.ApiConfigProcessor;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.meta.ApiMetadataBuilder;
import leap.web.api.meta.ApiMetadataContext;
import leap.web.api.meta.ApiMetadataFactory;
import leap.web.api.meta.ApiMetadataProcessor;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.api.restd.RestdProcessor;
import leap.web.api.restd.RestdStrategy;
import leap.web.api.restd.SimpleRestdContext;

public class RestdApiConfigProcessor
implements ApiConfigProcessor,
ApiMetadataProcessor {
    @Inject
    protected App app;
    @Inject
    protected RestdStrategy strategy;
    @Inject
    protected RestdProcessor[] processors;
    @Inject
    protected OrmMTypeFactory omf;
    @Inject
    protected OrmRegistry ormRegistry;
    @Inject
    protected ApiMetadataFactory amf;

    @Override
    public void preProcess(Api api) {
        RestdConfig rc = api.getConfig().getRestdConfig();
        if (null == rc) {
            return;
        }
        SimpleRestdContext restdContext = new SimpleRestdContext(api, rc);
        if (!rc.isNoDataSource()) {
            OrmContext oc = this.lookupOrmContext(rc);
            OrmMetadata om = oc.getMetadata();
            Dao dao = oc.getDao();
            Set<EntityMapping> ormModels = this.computeOrmModels(rc, om);
            Set<RestdModel> restdModels = this.createRestdModels(api, rc, oc, ormModels);
            restdContext.setDao(dao);
            restdContext.setModels(Collections.unmodifiableSet(restdModels));
        }
        this.processRestdApi(api, restdContext);
        api.getConfig().setExtension(RestdContext.class, restdContext);
    }

    @Override
    public void preProcess(ApiMetadataContext context, ApiMetadataBuilder m) {
        RestdContext restdContext = (RestdContext)context.getApi().getConfig().removeExtension(RestdContext.class);
        if (null == restdContext) {
            return;
        }
        Dao dao = restdContext.getDao();
        if (null == dao) {
            return;
        }
        OrmContext oc = dao.getOrmContext();
        MTypeContainer mtc = context.getMTypeContainer();
        for (RestdModel rm : restdContext.getModels()) {
            if (m.tryGetModel(rm.getName()) != null) continue;
            MComplexType mtype = this.omf.getMType(mtc, oc, rm.getEntityMapping());
            if (null != m.tryGetModel(rm.getEntityMapping().getEntityClass())) continue;
            this.amf.tryAddModel(context, m, mtype);
        }
        for (MComplexType ct : mtc.getComplexTypes().values()) {
            this.amf.tryAddModel(context, m, ct);
        }
    }

    protected void processRestdApi(Api api, RestdContext context) {
        ApiConfigurator c = api.getConfigurator();
        RestdConfig rc = context.getConfig();
        for (RestdProcessor p : this.processors) {
            p.preProcessApi(c, context);
        }
        for (RestdModel model : context.getModels()) {
            if (model.getEntityMapping().isRemote() && !rc.isAllowRemoteEntity()) continue;
            RestdProcessor[] restdProcessorArray = this.processors;
            int p = restdProcessorArray.length;
            for (int i = 0; i < p; ++i) {
                RestdProcessor p2 = restdProcessorArray[i];
                p2.preProcessModel(c, context, model);
            }
        }
        for (RestdModel model : context.getModels()) {
            if (model.getEntityMapping().isRemote() && !rc.isAllowRemoteEntity()) continue;
            for (RestdProcessor p2 : this.processors) {
                p2.postProcessModel(c, context, model);
            }
        }
        for (RestdProcessor p : this.processors) {
            p.postProcessApi(c, context);
        }
    }

    protected OrmContext lookupOrmContext(RestdConfig c) {
        String dataSourceName;
        OrmContext oc = c.getOrmContext();
        if (null == oc && null == (oc = this.ormRegistry.findContext(dataSourceName = Strings.firstNotEmpty((String[])new String[]{c.getDataSourceName(), "default"})))) {
            throw new ApiConfigException("Can't create restd api , orm context '" + dataSourceName + "' has not been registered!");
        }
        return oc;
    }

    protected Set<RestdModel> createRestdModels(Api api, RestdConfig c, OrmContext oc, Set<EntityMapping> ormModels) {
        LinkedHashSet<RestdModel> restdModels = new LinkedHashSet<RestdModel>();
        for (EntityMapping em : ormModels) {
            RestdConfig.Model cm = c.getModel(em.getEntityName());
            if (null == cm && !c.isAutoConfigureEntities()) continue;
            RestdModel.Builder rm = new RestdModel.Builder(em);
            if (null != cm && !Strings.isEmpty((String)cm.getPath())) {
                rm.setPath(cm.getPath());
            } else {
                rm.setPath(this.strategy.getDefaultModelPath(em.getEntityName()));
            }
            if (null != cm) {
                rm.setAttrs(cm.getAttributes());
            }
            restdModels.add(rm.build());
        }
        return restdModels;
    }

    protected Set<EntityMapping> computeOrmModels(RestdConfig c, OrmMetadata om) {
        List ems = om.getEntityMappingSnapshotList();
        LinkedHashSet<EntityMapping> includes = new LinkedHashSet<EntityMapping>();
        boolean includesAll = c.getIncludedModels().isEmpty();
        if (!includesAll) {
            ems.forEach(em -> c.getIncludedModels().forEach(pattern -> {
                if (this.matchesModel((String)pattern, em.getEntityName())) {
                    includes.add((EntityMapping)em);
                }
            }));
        } else {
            includes.addAll(ems);
        }
        if (!includes.isEmpty()) {
            HashSet excludes = new HashSet();
            includes.forEach(em -> c.getExcludedModels().forEach(pattern -> {
                if (this.matchesModel((String)pattern, em.getEntityName())) {
                    excludes.add(em);
                }
            }));
            if (!excludes.isEmpty()) {
                excludes.forEach(includes::remove);
            }
        }
        return includes;
    }

    protected boolean matchesModel(String pattern, String name) {
        if (pattern.equals("*")) {
            return true;
        }
        return new AntPathPattern(pattern).matches(name);
    }
}

