/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd;

import java.util.Map;
import leap.core.annotation.Inject;
import leap.web.api.config.ApiConfigException;
import leap.web.api.config.ApiConfigurator;
import leap.web.api.config.model.RestdConfig;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.api.restd.RestdOperationDef;
import leap.web.api.restd.RestdOperationProvider;
import leap.web.api.restd.RestdProcessor;

public class ProviderOperationProcessor
implements RestdProcessor {
    @Inject
    protected Map<String, RestdOperationProvider> providers;

    @Override
    public void preProcessApi(ApiConfigurator c, RestdContext context) {
        context.getConfig().getOperations().forEach(o -> this.provider((RestdConfig.Operation)o).createApiOperation(context, (RestdOperationDef)o));
    }

    @Override
    public void preProcessModel(ApiConfigurator c, RestdContext context, RestdModel model) {
        RestdConfig.Model mc = context.getConfig().getModel(model.getName());
        if (null == mc) {
            return;
        }
        mc.getOperations().values().forEach(o -> this.provider((RestdConfig.Operation)o).createModelOperation(context, model, (RestdOperationDef)o));
    }

    protected RestdOperationProvider provider(RestdConfig.Operation o) {
        String type = o.getType();
        RestdOperationProvider provider = this.providers.get(type);
        if (null == provider) {
            throw new ApiConfigException("Restd operation type '" + type + "' not found");
        }
        return provider;
    }
}

