/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd;

import java.util.LinkedHashMap;
import java.util.Map;
import leap.lang.Beans;
import leap.orm.mapping.EntityMapping;
import leap.web.api.restd.RestdModel;

public class CrudUtils {
    public static String getIdPathTemplate(RestdModel rm) {
        return CrudUtils.getIdPathTemplate(rm.getEntityMapping());
    }

    public static String getIdPathTemplate(EntityMapping em) {
        if (em.getKeyFieldNames().length == 1) {
            return "/{" + em.getKeyFieldNames()[0] + "}";
        }
        StringBuilder p = new StringBuilder();
        p.append('/');
        for (int i = 0; i < em.getKeyFieldNames().length; ++i) {
            String name = em.getKeyFieldNames()[i];
            if (i > 0) {
                p.append(',');
            }
            p.append('{').append(name).append('}');
        }
        return p.toString();
    }

    public static String getIdPath(EntityMapping em, Object id) {
        if (em.getKeyFieldNames().length == 1) {
            return "/" + id;
        }
        if (id instanceof Map) {
            return CrudUtils.getIdPath(em, (Map)id);
        }
        return CrudUtils.getIdPath(em, Beans.toMap((Object)id));
    }

    public static Object getSingleOrMap(Map<String, Object> record, String ... fields) {
        if (fields.length == 0) {
            return null;
        }
        if (fields.length == 1) {
            return record.get(fields[0]);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String field : fields) {
            Object v = record.get(field);
            if (null == v) continue;
            result.put(field, v);
        }
        return result.isEmpty() ? null : result;
    }

    protected static String getIdPath(EntityMapping em, Map<String, Object> id) {
        StringBuilder s = new StringBuilder();
        s.append('/');
        for (int i = 0; i < em.getKeyFieldNames().length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(id.get(em.getKeyFieldNames()[i]));
        }
        return s.toString();
    }

    protected CrudUtils() {
    }
}

