/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.restd;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import leap.core.annotation.Inject;
import leap.lang.Strings;
import leap.lang.meta.MCollectionType;
import leap.lang.meta.MComplexTypeRef;
import leap.lang.meta.MSimpleTypes;
import leap.lang.meta.MType;
import leap.orm.dao.Dao;
import leap.orm.mapping.EntityMapping;
import leap.orm.mapping.FieldMapping;
import leap.web.action.ActionParams;
import leap.web.action.Argument;
import leap.web.action.ArgumentBuilder;
import leap.web.action.FuncActionBuilder;
import leap.web.api.Api;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiHeaderBuilder;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.meta.model.MApiParameter;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.orm.ModelExecutorFactory;
import leap.web.api.restd.CrudUtils;
import leap.web.api.restd.RestdArgumentSupport;
import leap.web.api.restd.RestdContext;
import leap.web.api.restd.RestdModel;
import leap.web.api.restd.RestdOperationBase;
import leap.web.route.RouteBuilder;

public abstract class CrudOperationBase
extends RestdOperationBase {
    @Inject
    protected ModelExecutorFactory mef;

    protected void setApiExtension(RouteBuilder route, String name, Object value) {
        MApiExtension extension = (MApiExtension)((Object)route.getExtension(MApiExtension.class));
        if (null == extension) {
            extension = new MApiExtension();
            route.setExtension((Object)extension);
        }
        extension.setAttribute(name, value);
    }

    protected void setCrudOperation(RouteBuilder route, String operation) {
        this.setApiExtension(route, "crud", operation);
    }

    protected ArgumentBuilder addModelArgumentForCreate(RestdContext context, FuncActionBuilder action, RestdModel model) {
        ArgumentBuilder a = this.newModelArgument(model);
        for (RestdArgumentSupport vs : this.argumentSupports) {
            vs.processModelArgumentForCreate(context, model, a);
        }
        action.addArgument(a);
        return a;
    }

    protected ArgumentBuilder addModelArgumentForUpdate(RestdContext context, FuncActionBuilder action, RestdModel model) {
        ArgumentBuilder a = this.newModelArgument(model);
        for (RestdArgumentSupport vs : this.argumentSupports) {
            vs.processModelArgumentForUpdate(context, model, a);
        }
        action.addArgument(a);
        return a;
    }

    protected ArgumentBuilder addModelArgumentForReplace(RestdContext context, FuncActionBuilder action, RestdModel model) {
        ArgumentBuilder a = this.newModelArgument(model);
        for (RestdArgumentSupport vs : this.argumentSupports) {
            vs.processModelArgumentForReplace(context, model, a);
        }
        action.addArgument(a);
        return a;
    }

    protected void addIdArguments(RestdContext context, FuncActionBuilder action, RestdModel model) {
        for (FieldMapping id : model.getEntityMapping().getKeyFieldMappings()) {
            ArgumentBuilder a = this.newIdArgument(model, id);
            for (RestdArgumentSupport vs : this.argumentSupports) {
                vs.processIdArgument(context, model, a);
            }
            action.addArgument(a);
        }
    }

    protected MApiResponseBuilder addModelResponse(FuncActionBuilder action, RestdModel model) {
        action.setReturnType(ApiResponse.class);
        MApiResponseBuilder r = this.newModelResponse(model);
        r.setDescription("Success");
        action.setExtension((Object)new MApiResponseBuilder[]{r});
        return r;
    }

    protected MApiResponseBuilder addNoContentResponse(FuncActionBuilder action, RestdModel model) {
        action.setReturnType(ApiResponse.class);
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(204);
        r.setDescription("Success");
        action.setExtension((Object)new MApiResponseBuilder[]{r});
        return r;
    }

    protected MApiResponseBuilder addModelQueryResponse(FuncActionBuilder action, RestdModel model) {
        action.setReturnType(ApiResponse.class);
        MApiResponseBuilder r = this.newModelQueryResponse(model);
        action.setExtension((Object)new MApiResponseBuilder[]{r});
        return r;
    }

    protected MApiResponseBuilder addModelQueryResponse(FuncActionBuilder action, String typeName) {
        action.setReturnType(ApiResponse.class);
        MApiResponseBuilder r = this.newModelQueryResponse(typeName);
        action.setExtension((Object)new MApiResponseBuilder[]{r});
        return r;
    }

    protected MApiResponseBuilder addModelCountResponse(FuncActionBuilder action, RestdModel model) {
        action.setReturnType(Long.class);
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(200);
        r.setType((MType)MSimpleTypes.BIGINT);
        r.setDescription("Success");
        return r;
    }

    protected MApiResponseBuilder newModelResponse(RestdModel model) {
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(200);
        r.setType((MType)new MComplexTypeRef(model.getName()));
        r.setDescription("Success");
        return r;
    }

    protected MApiResponseBuilder newModelQueryResponse(RestdModel model) {
        return this.newModelQueryResponse(model.getName());
    }

    protected MApiResponseBuilder newModelQueryResponse(String typeName) {
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(200);
        r.setType((MType)new MCollectionType((MType)new MComplexTypeRef(typeName)));
        r.setDescription("Success");
        MApiHeaderBuilder header = new MApiHeaderBuilder();
        header.setName("X-Total-Count");
        header.setType((MType)MSimpleTypes.BIGINT);
        header.setDescription("The total count of query records.");
        r.addHeader(header);
        return r;
    }

    protected ArgumentBuilder newModelArgument(RestdModel model) {
        ArgumentBuilder a = new ArgumentBuilder();
        a.setName(model.getName());
        a.setLocation(Argument.Location.REQUEST_BODY);
        a.setType(Map.class);
        a.setRequired(Boolean.valueOf(true));
        a.setExtension((Object)this.newModelParameter(model));
        return a;
    }

    private MApiParameterBuilder newModelParameter(RestdModel model) {
        MApiParameterBuilder p = new MApiParameterBuilder();
        p.setName(Strings.lowerCamel((String[])new String[]{model.getName()}));
        p.setLocation(MApiParameter.Location.BODY);
        p.setRequired(true);
        p.setType((MType)new MComplexTypeRef(model.getName()));
        return p;
    }

    protected ArgumentBuilder newIdArgument(RestdModel model, FieldMapping id) {
        ArgumentBuilder a = new ArgumentBuilder();
        a.setName(id.getFieldName());
        a.setLocation(Argument.Location.PATH_PARAM);
        a.setType(id.getJavaType());
        a.setRequired(Boolean.valueOf(true));
        a.setExtension((Object)this.newIdParameter(model, id));
        return a;
    }

    protected String getIdPath(RestdModel model) {
        return CrudUtils.getIdPathTemplate(model);
    }

    private MApiParameterBuilder newIdParameter(RestdModel model, FieldMapping id) {
        MApiParameterBuilder p = new MApiParameterBuilder();
        p.setName(id.getFieldName());
        p.setLocation(MApiParameter.Location.PATH);
        p.setRequired(true);
        p.setType(id.getDataType());
        return p;
    }

    protected static abstract class CrudFunction
    implements Function<ActionParams, Object> {
        protected final Api api;
        protected final Dao dao;
        protected final RestdModel model;
        protected final EntityMapping em;
        protected final int start;
        protected final int idLen;
        private MApiModel am;

        protected CrudFunction(Api api, Dao dao, RestdModel model, int start) {
            this.api = api;
            this.dao = dao;
            this.model = model;
            this.em = model.getEntityMapping();
            this.start = start;
            this.idLen = this.em.getKeyFieldMappings().length;
        }

        protected MApiModel am() {
            if (null == this.am) {
                this.am = this.api.getMetadata().getModel(this.model.getName());
            }
            return this.am;
        }

        protected final Object id(ActionParams params) {
            if (this.idLen > 1) {
                HashMap<String, Object> id = new HashMap<String, Object>(this.idLen);
                for (int i = this.start; i < this.idLen; ++i) {
                    id.put(this.em.getKeyFieldNames()[i], params.get(i));
                }
                return id;
            }
            return params.get(this.start);
        }

        protected final <T> T getWithId(ActionParams params, int index) {
            return (T)params.get(this.start + this.idLen + index);
        }

        protected final <T> T getWithoutId(ActionParams params, int index) {
            return (T)params.get(this.start + index);
        }

        protected final Map recordWithId(ActionParams params) {
            return (Map)params.get(this.start + this.idLen);
        }
    }

    public static interface Callback {
        default public void preAddArguments(FuncActionBuilder action) {
        }

        default public void postAddArguments(FuncActionBuilder action) {
        }
    }
}

