/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import leap.web.api.remote.json.ParameterizedTypeImpl;

public class TypeReference<T> {
    static ConcurrentMap<Type, Type> classTypeCache = new ConcurrentHashMap<Type, Type>(16, 0.75f, 1);
    protected final Type type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    protected TypeReference(Type ... actualTypeArguments) {
        ParameterizedTypeImpl key;
        Type cachedType;
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type rawType = argType.getRawType();
        Type[] argTypes = argType.getActualTypeArguments();
        int actualIndex = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (!(argTypes[i] instanceof TypeVariable)) continue;
            argTypes[i] = actualTypeArguments[actualIndex++];
            if (actualIndex >= actualTypeArguments.length) break;
        }
        if ((cachedType = (Type)classTypeCache.get(key = new ParameterizedTypeImpl(argTypes, thisClass, rawType))) == null) {
            classTypeCache.putIfAbsent(key, key);
            cachedType = (Type)classTypeCache.get(key);
        }
        this.type = cachedType;
    }

    public Type getType() {
        return this.type;
    }
}

