/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote.ds;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.core.BeanFactory;
import leap.core.ioc.PostCreateBean;
import leap.lang.exception.ObjectExistsException;
import leap.web.api.remote.ds.RestDataSource;
import leap.web.api.remote.ds.RestDatasourceManager;

public class DefaultRestDataSourceManager
implements RestDatasourceManager,
PostCreateBean {
    protected Map<String, RestDataSource> allDataSources;
    protected Map<String, RestDataSource> allDataSourcesImmutableView;

    @Override
    public boolean hasDataSources() {
        return this.allDataSources != null && this.allDataSources.size() != 0;
    }

    @Override
    public RestDataSource tryGetDataSource(String name) {
        if (!this.hasDataSources()) {
            return null;
        }
        return this.allDataSources.get(name);
    }

    @Override
    public Map<String, RestDataSource> getAllDataSources() {
        return this.allDataSourcesImmutableView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDataSource(String name, RestDataSource ds) throws ObjectExistsException {
        DefaultRestDataSourceManager defaultRestDataSourceManager = this;
        synchronized (defaultRestDataSourceManager) {
            if (this.allDataSources.containsKey(name)) {
                throw new ObjectExistsException("DataSource '" + name + "' already exists!");
            }
            this.allDataSources.put(name, ds);
        }
    }

    @Override
    public boolean removeDataSource(String name) {
        return null != this.allDataSources.remove(name);
    }

    public void postCreate(BeanFactory factory) throws Throwable {
        this.allDataSources = new ConcurrentHashMap<String, RestDataSource>(factory.getNamedBeans(RestDataSource.class));
        this.allDataSourcesImmutableView = Collections.unmodifiableMap(this.allDataSources);
    }
}

