/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote;

import leap.core.annotation.Inject;
import leap.lang.Strings;
import leap.lang.http.HTTP;
import leap.lang.http.client.HttpRequest;
import leap.oauth2.webapp.code.DefaultCodeVerifier;
import leap.oauth2.webapp.token.Token;
import leap.oauth2.webapp.token.TokenContext;
import leap.oauth2.webapp.token.TokenExtractor;
import leap.oauth2.webapp.token.at.AccessToken;
import leap.oauth2.webapp.token.at.SimpleAccessToken;
import leap.web.Request;

public class TokenFetcher
extends DefaultCodeVerifier {
    @Inject
    protected TokenExtractor tokenExtractor;
    private volatile AccessToken clientAccessToken;

    public AccessToken getAccessToken(Request request, boolean canNewAccessToken) {
        AccessToken at = TokenContext.getAccessToken();
        if (at != null) {
            return at;
        }
        Token token = this.tokenExtractor.extractTokenFromRequest(request);
        if (token != null) {
            return new SimpleAccessToken(token.getToken());
        }
        if (!canNewAccessToken) {
            return null;
        }
        if (null == this.config.getTokenUrl()) {
            return null;
        }
        if (null == this.clientAccessToken) {
            this.newClientAccessToken();
        } else if (this.clientAccessToken.isExpired()) {
            this.refreshAccessToken(this.clientAccessToken);
        }
        return this.clientAccessToken;
    }

    private AccessToken newClientAccessToken() {
        if (null == this.config.getTokenUrl()) {
            throw new IllegalStateException("The tokenUrl must be configured");
        }
        HttpRequest request = this.httpClient.request(this.config.getTokenUrl()).addQueryParam("grant_type", "client_credentials").setMethod(HTTP.Method.POST);
        this.clientAccessToken = this.fetchAccessToken(request);
        return this.clientAccessToken;
    }

    public AccessToken refreshAccessToken(AccessToken old) {
        if (Strings.isEmpty((String)old.getRefreshToken())) {
            return this.newClientAccessToken();
        }
        HttpRequest request = this.httpClient.request(this.config.getTokenUrl()).addQueryParam("grant_type", "refresh_token").addQueryParam("refresh_token", old.getRefreshToken()).setMethod(HTTP.Method.POST);
        this.clientAccessToken = this.fetchAccessToken(request);
        return this.clientAccessToken;
    }
}

