/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import leap.core.AppContext;
import leap.lang.Assert;
import leap.lang.Strings;
import leap.lang.http.client.HttpRequest;
import leap.lang.http.client.HttpResponse;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.path.Paths;
import leap.oauth2.webapp.token.at.AccessToken;
import leap.orm.enums.RemoteType;
import leap.orm.mapping.EntityMapping;
import leap.web.Request;
import leap.web.api.remote.DefaultRestResource;
import leap.web.api.remote.RestResource;
import leap.web.api.remote.ds.RestDataSource;
import leap.web.api.remote.ds.RestDatasourceManager;

public class RestResourceBuilder {
    private static Log logger = LogFactory.get(RestResourceBuilder.class);
    private static String localIP;
    private String endpoint;
    private EntityMapping entityMapping;
    private AccessToken accessToken;
    private Consumer<HttpRequest> preSendHandler;
    private Consumer<HttpResponse> postSendHandler;

    public static RestResourceBuilder newBuilder() {
        return new RestResourceBuilder();
    }

    public RestResource build() {
        DefaultRestResource res = (DefaultRestResource)AppContext.factory().inject((Object)new DefaultRestResource(this.entityMapping));
        res.setPreSendHandler(this.preSendHandler);
        res.setPostSendHandler(this.postSendHandler);
        if (this.accessToken != null) {
            res.setAccessToken(this.accessToken);
        }
        if (this.entityMapping != null) {
            RestDatasourceManager manager = this.getDataSourceManager();
            RestDataSource ds = manager.tryGetDataSource(this.entityMapping.getRemoteSettings().getDataSource());
            String basePath = this.entityMapping.getRemoteSettings().getEndpoint();
            if (ds != null && Strings.isNotEmpty((String)ds.getEndpoint())) {
                basePath = ds.getEndpoint();
            }
            if (Strings.isNotEmpty((String)basePath)) {
                String url = Paths.suffixWithSlash((String)basePath) + this.entityMapping.getRemoteSettings().getRelativePath();
                res.setEndpoint(url);
            }
        }
        if (Strings.isNotBlank((String)this.endpoint)) {
            res.setEndpoint(this.endpoint);
        }
        if (Strings.isEmpty((String)res.getEndpoint())) {
            throw new RuntimeException("can't build rest resource,when endpoint or entityMapping is empty!");
        }
        res.setEndpoint(RestResourceBuilder.formatApiEndPoint(res.getEndpoint()));
        return res;
    }

    public static String formatApiEndPoint(String apiEndPoint) {
        HttpServletRequest request;
        if (apiEndPoint.contains("{context}")) {
            String contextPath = Request.tryGetCurrent().getServletRequest().getContextPath();
            apiEndPoint = apiEndPoint.replace("{context}", Strings.trimStart((String)contextPath, (char[])new char[]{'/'}));
        }
        if (apiEndPoint.contains("~")) {
            request = Request.tryGetCurrent().getServletRequest();
            apiEndPoint = apiEndPoint.replace("~", Strings.format((String)"{0}://{1}:{2}", (Object[])new Object[]{request.getScheme(), RestResourceBuilder.curServerLocalIp(), request.getLocalPort()}));
        }
        if (apiEndPoint.startsWith("/")) {
            request = Request.tryGetCurrent().getServletRequest();
            apiEndPoint = Strings.format((String)"{0}://{1}:{2}", (Object[])new Object[]{request.getScheme(), "127.0.0.1", request.getLocalPort()}) + apiEndPoint;
        }
        if (Strings.endsWith((String)apiEndPoint, (String)"/")) {
            apiEndPoint = Strings.trimEnd((String)apiEndPoint, (char[])new char[]{'/'});
        }
        return apiEndPoint;
    }

    private static String curServerLocalIp() {
        if (!Strings.isEmpty((String)localIP)) {
            return localIP;
        }
        String serverIP = null;
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                if (!ni.getInetAddresses().hasMoreElements()) continue;
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                for (InetAddress ip : Collections.list(inetAddresses)) {
                    logger.info("ip info:{},,isLoop:{},hostAddr:{},isSiteLocal:{}", new Object[]{ip, ip.isLoopbackAddress(), ip.getHostAddress(), ip.isSiteLocalAddress()});
                    if (ip instanceof Inet6Address || ip.isLoopbackAddress()) continue;
                    serverIP = ip.getHostAddress();
                    if (!ip.isSiteLocalAddress()) continue;
                    break;
                }
                if (!Strings.isNotBlank(serverIP)) continue;
                break;
            }
        }
        catch (SocketException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        localIP = serverIP;
        return localIP;
    }

    private RestDatasourceManager getDataSourceManager() {
        return (RestDatasourceManager)AppContext.getBean(RestDatasourceManager.class);
    }

    public RestResourceBuilder setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public RestResourceBuilder setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Consumer<HttpRequest> getPreSendHandler() {
        return this.preSendHandler;
    }

    public RestResourceBuilder setPreSendHandler(Consumer<HttpRequest> preSendHandler) {
        this.preSendHandler = preSendHandler;
        return this;
    }

    public Consumer<HttpResponse> getPostSendHandler() {
        return this.postSendHandler;
    }

    public RestResourceBuilder setPostSendHandler(Consumer<HttpResponse> postSendHandler) {
        this.postSendHandler = postSendHandler;
        return this;
    }

    public RestResourceBuilder setEntityMapping(EntityMapping entityMapping) {
        Assert.notNull((Object)entityMapping, (String)"entity mapping can't be null.");
        Assert.isTrue((entityMapping.isRemote() && RemoteType.rest.equals((Object)entityMapping.getRemoteSettings().getRemoteType()) ? 1 : 0) != 0, (String)"entity must be remote rest model.");
        this.entityMapping = entityMapping;
        return this;
    }
}

