/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote;

import leap.core.annotation.Inject;
import leap.lang.Strings;
import leap.lang.http.client.HttpClient;
import leap.lang.path.Paths;
import leap.orm.OrmContext;
import leap.orm.mapping.EntityMapping;
import leap.web.api.remote.DefaultRestResource;
import leap.web.api.remote.RestResource;
import leap.web.api.remote.RestResourceBuilder;
import leap.web.api.remote.RestResourceFactory;
import leap.web.api.remote.TokenFetcher;
import leap.web.api.remote.ds.RestDataSource;
import leap.web.api.remote.ds.RestDatasourceManager;

public class DefaultRestResourceFactory
implements RestResourceFactory {
    @Inject
    protected HttpClient httpClient;
    @Inject
    protected TokenFetcher tokenFetcher;
    @Inject
    protected RestDatasourceManager dsm;

    @Override
    public RestResource createResource(OrmContext context, EntityMapping em) {
        if (!em.isRemoteRest()) {
            return null;
        }
        RestResourceInfo rri = (RestResourceInfo)em.getExtension(RestResourceInfo.class);
        if (null == rri) {
            String basePath = em.getRemoteSettings().getEndpoint();
            if (Strings.isEmpty((String)basePath) && null != em.getRemoteSettings().getDataSource()) {
                RestDataSource ds = this.dsm.tryGetDataSource(em.getRemoteSettings().getDataSource());
                if (null == ds) {
                    throw new IllegalStateException("Remote dataSource '" + em.getRemoteSettings().getDataSource() + "' not found, check entity '" + em.getEntityName() + "'");
                }
                basePath = ds.getEndpoint();
            }
            if (Strings.isEmpty((String)basePath)) {
                throw new IllegalStateException("Remote endpoint must be configured, check entity '" + em.getEntityName() + "'");
            }
            String endpoint = Paths.suffixWithSlash((String)basePath) + em.getRemoteSettings().getRelativePath();
            rri = new RestResourceInfo(RestResourceBuilder.formatApiEndPoint(endpoint));
            em.setExtension(RestResourceInfo.class, (Object)rri);
        }
        return this.doCreateResource(context, em, rri);
    }

    protected RestResource doCreateResource(OrmContext context, EntityMapping em, RestResourceInfo info) {
        DefaultRestResource restResource = new DefaultRestResource(em);
        restResource.setHttpClient(this.httpClient);
        restResource.setTokenFetcher(this.tokenFetcher);
        restResource.setEndpoint(info.getEndpoint());
        return restResource;
    }

    public static final class RestResourceInfo {
        protected final String endpoint;

        public RestResourceInfo(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

