/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import leap.core.value.Record;
import leap.core.value.SimpleRecord;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.http.ContentTypes;
import leap.lang.http.HTTP;
import leap.lang.http.client.HttpRequest;
import leap.lang.http.client.HttpResponse;
import leap.lang.json.JSON;
import leap.lang.json.JsonSettings;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.oauth2.webapp.token.at.AccessToken;
import leap.orm.mapping.EntityMapping;
import leap.web.api.mvc.params.CountOptions;
import leap.web.api.mvc.params.DeleteOptions;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.remote.AbstractRestResource;
import leap.web.api.remote.RestQueryListResult;
import leap.web.api.remote.RestResourceInvokeException;
import leap.web.api.remote.json.TypeReference;
import leap.web.api.restd.CrudUtils;

public class DefaultRestResource
extends AbstractRestResource {
    private final Log log = LogFactory.get(DefaultRestResource.class);
    protected final EntityMapping em;
    protected String endpoint;
    protected AccessToken at;

    public DefaultRestResource(EntityMapping em) {
        this.em = em;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    protected AccessToken getAccessToken() {
        if (this.at != null) {
            return this.at;
        }
        return super.getAccessToken();
    }

    public void setAccessToken(AccessToken token) {
        this.at = token;
    }

    @Override
    public <T> T insert(Class<T> resultClass, Object obj) {
        String op = "";
        HttpRequest request = this.httpClient.request(this.buildOperationPath(op)).ajax().setJson(JSON.encode((Object)obj, (JsonSettings)JsonSettings.MIN)).setMethod(HTTP.Method.POST);
        Object val = this.send(resultClass, request, this.getAccessToken());
        return val;
    }

    @Override
    public Record create(Map<String, Object> properties) {
        return new SimpleRecord(this.insert(Map.class, properties));
    }

    @Override
    public boolean delete(Object id, DeleteOptions options) {
        String op = this.idPath(id);
        HttpRequest request = this.httpClient.request(this.buildOperationPath(op)).ajax().setMethod(HTTP.Method.DELETE);
        if (options != null && options.isCascadeDelete()) {
            request.addQueryParam("cascade_delete", "true");
        }
        return Boolean.TRUE == this.send((Type)((Object)Boolean.class), request, this.getAccessToken());
    }

    @Override
    public boolean update(Object id, Object partial) {
        String op = this.idPath(id);
        HttpRequest request = this.httpClient.request(this.buildOperationPath(op)).ajax().setJson(JSON.encode((Object)partial, (JsonSettings)JsonSettings.MIN)).setMethod(HTTP.Method.PATCH);
        return Boolean.TRUE == this.send((Type)((Object)Boolean.class), request, this.getAccessToken());
    }

    @Override
    public <T> T find(Class<T> entityClass, Object id, QueryOptionsBase options) {
        String op = this.idPath(id);
        return this.doFind(entityClass, this.buildOperationPath(op), options);
    }

    @Override
    public <T> T findRelationOne(Class<T> resultClass, String relationPath, Object id, QueryOptionsBase options) {
        String op = this.idPath(id) + "/" + relationPath;
        return this.doFind(resultClass, this.buildOperationPath(op), options);
    }

    protected <T> T doFind(Class<T> resultClass, String url, QueryOptionsBase options) {
        HttpRequest request = this.httpClient.request(url).ajax().setMethod(HTTP.Method.GET);
        this.buildQueryOption(request, options);
        return this.send(resultClass, request, this.getAccessToken());
    }

    @Override
    public <T> RestQueryListResult<T> queryList(Class<T> resultElementClass, QueryOptions options, Map<String, Object> filters) {
        String op = "";
        this.applyFilters(options, filters);
        return this.doQueryList(resultElementClass, this.buildOperationPath(op), options);
    }

    @Override
    public <T> RestQueryListResult<T> queryRelationList(Class<T> resultElementClass, String relationPath, Object id, QueryOptions options) {
        String op = this.idPath(id) + "/" + relationPath;
        return this.doQueryList(resultElementClass, this.buildOperationPath(op), options);
    }

    protected <T> RestQueryListResult<T> doQueryList(Class<T> resultElementClass, String url, QueryOptions options) {
        HttpRequest request = this.httpClient.request(url).ajax().setMethod(HTTP.Method.GET);
        this.buildQueryOption(request, options);
        Out out = new Out();
        Type targetType = new TypeReference<List<T>>(new Type[]{resultElementClass}){}.getType();
        this.send(request, this.getAccessToken(), (HttpResponse response) -> {
            String content = response.getString();
            this.log.debug("status:{},Received response : {}", new Object[]{response.getStatus(), content});
            if (response.is2xx()) {
                List list = new ArrayList();
                if (Strings.isNotEmpty((String)content) && ContentTypes.APPLICATION_JSON_TYPE.isCompatible(response.getContentType())) {
                    list = (List)this.decode(targetType, content);
                }
                int count = list.size();
                String countStr = response.getHeader("X-Total-Count");
                if (options.isTotal() && Strings.isNotBlank((String)countStr)) {
                    count = Integer.parseInt(countStr);
                }
                out.accept(new RestQueryListResult(list, count));
                return;
            }
            throw new RestResourceInvokeException((HttpResponse)response);
        });
        if (out.isEmpty()) {
            return null;
        }
        return (RestQueryListResult)out.get();
    }

    @Override
    public int count(CountOptions options) {
        Integer val;
        String op = "/count";
        HttpRequest request = this.httpClient.request(this.buildOperationPath(op)).ajax().setMethod(HTTP.Method.GET);
        if (options != null && Strings.isNotEmpty((String)options.getFilters())) {
            request.addQueryParam("filters", options.getFilters());
        }
        return (val = (Integer)this.send((Type)((Object)Integer.class), request, this.getAccessToken())) == null ? 0 : val;
    }

    protected String idPath(Object id) {
        return null == this.em ? "/" + id : CrudUtils.getIdPath(this.em, id);
    }

    protected void applyFilters(QueryOptions options, Map<String, Object> filters) {
        if (null == filters || filters.isEmpty()) {
            return;
        }
        StringBuilder filtersBuilder = new StringBuilder();
        String opFilters = options.getFilters();
        if (!Strings.isEmpty((String)opFilters)) {
            filtersBuilder.append(opFilters);
        }
        filters.forEach((field, value) -> {
            List list;
            if (!Strings.isEmpty((String)filtersBuilder.toString())) {
                filtersBuilder.append(" and ");
            }
            if (null == value) {
                filtersBuilder.append((String)field).append(" is null");
            } else if (value instanceof String) {
                filtersBuilder.append((String)field).append(" eq ").append(value);
            } else if (value instanceof List && !(list = (List)value).isEmpty()) {
                filtersBuilder.append((String)field).append(" in ").append(Strings.join((Iterable)list, (String)","));
            }
        });
        options.setFilters(filtersBuilder.toString());
    }
}

