/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.remote;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import leap.core.annotation.Inject;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.http.ContentTypes;
import leap.lang.http.HTTP;
import leap.lang.http.client.HttpClient;
import leap.lang.http.client.HttpRequest;
import leap.lang.http.client.HttpResponse;
import leap.lang.json.JSON;
import leap.lang.json.JsonParsable;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.oauth2.webapp.OAuth2Constants;
import leap.oauth2.webapp.token.at.AccessToken;
import leap.web.Request;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.remote.RestResource;
import leap.web.api.remote.RestResourceInvokeException;
import leap.web.api.remote.TokenFetcher;

public abstract class AbstractRestResource
implements RestResource {
    private final Log log = LogFactory.get(AbstractRestResource.class);
    @Inject
    protected HttpClient httpClient;
    @Inject
    protected TokenFetcher tokenFetcher;
    private boolean canNewAccessToken;
    private Consumer<HttpRequest> preSendHandler;
    private Consumer<HttpResponse> postSendHandler;

    @Override
    public boolean isCanNewAccessToken() {
        return this.canNewAccessToken;
    }

    @Override
    public void setCanNewAccessToken(boolean canNewAccessToken) {
        this.canNewAccessToken = canNewAccessToken;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setTokenFetcher(TokenFetcher tokenFetcher) {
        this.tokenFetcher = tokenFetcher;
    }

    public Consumer<HttpRequest> getPreSendHandler() {
        return this.preSendHandler;
    }

    public void setPreSendHandler(Consumer<HttpRequest> preSendHandler) {
        this.preSendHandler = preSendHandler;
    }

    public Consumer<HttpResponse> getPostSendHandler() {
        return this.postSendHandler;
    }

    public void setPostSendHandler(Consumer<HttpResponse> postSendHandler) {
        this.postSendHandler = postSendHandler;
    }

    protected abstract String getEndpoint();

    protected AccessToken getAccessToken() {
        Request request = Request.tryGetCurrent();
        if (request == null) {
            return null;
        }
        AccessToken at = this.tokenFetcher.getAccessToken(request, this.canNewAccessToken);
        return at;
    }

    protected String buildOperationPath(String relativePath) {
        String baseUrl = this.getEndpoint();
        return this.mergePath(baseUrl, relativePath);
    }

    protected String mergePath(String parentPath, String relativePath) {
        parentPath = Strings.trimEnd((String)parentPath, (char[])new char[]{'/'});
        if (Strings.isEmpty((String)relativePath)) {
            return parentPath;
        }
        if (!relativePath.startsWith("/")) {
            relativePath = "/" + relativePath;
        }
        return parentPath + relativePath;
    }

    protected void send(HttpRequest request, AccessToken at, Consumer<HttpResponse> consumer) {
        HttpResponse response;
        if (at != null) {
            request.setHeader("Authorization", OAuth2Constants.BEARER + " " + at.getToken());
        }
        if (this.preSendHandler != null) {
            this.preSendHandler.accept(request);
        }
        if ((response = request.send()).getStatus() == HTTP.SC_UNAUTHORIZED && at != null) {
            if (null == (at = this.tokenFetcher.refreshAccessToken(at))) {
                throw new RestResourceInvokeException(response);
            }
            request.setHeader("Authorization", OAuth2Constants.BEARER + " " + at.getToken());
            response = request.send();
        }
        consumer.accept(response);
        if (this.postSendHandler != null) {
            this.postSendHandler.accept(response);
        }
    }

    protected <T> T send(Type targetType, HttpRequest request, AccessToken at) {
        Out out = new Out();
        this.send(request, at, (HttpResponse response) -> {
            String content = response.getString();
            this.log.debug("status:{},Received response : {}", new Object[]{response.getStatus(), content});
            if (response.is2xx()) {
                if (Boolean.class.equals((Object)targetType)) {
                    out.set((Object)Boolean.TRUE);
                    return;
                }
                if (Strings.isEmpty((String)content)) {
                    return;
                }
                if (targetType != null && ContentTypes.APPLICATION_JSON_TYPE.isCompatible(response.getContentType())) {
                    out.accept(this.decode(targetType, content));
                }
                return;
            }
            if (response.isNotFound()) {
                return;
            }
            throw new RestResourceInvokeException((HttpResponse)response);
        });
        if (out.isEmpty()) {
            return null;
        }
        return (T)out.get();
    }

    protected <T> T decode(Type targetType, String jsonStr) {
        Object val;
        if (Strings.isEmpty((String)jsonStr)) {
            return null;
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)targetType;
            Class rawType = (Class)pType.getRawType();
            Type[] actualTypes = pType.getActualTypeArguments();
            if (rawType.isAssignableFrom(List.class)) {
                Object[] arr = JSON.decodeArray((String)jsonStr, (Class)((Class)actualTypes[0]));
                List val2 = Arrays.stream(arr).collect(Collectors.toList());
                return (T)val2;
            }
            if (rawType.isAssignableFrom(Map.class)) {
                Map val3 = JSON.decodeMap((String)jsonStr, (Class)((Class)actualTypes[0]));
                return (T)val3;
            }
            throw new RuntimeException("unsupported type:" + targetType.getTypeName());
        }
        Class cls = (Class)targetType;
        if (JsonParsable.class.isAssignableFrom(cls)) {
            JsonParsable temp;
            try {
                temp = (JsonParsable)cls.newInstance();
                temp.parseJson(jsonStr);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            val = temp;
        } else {
            val = JSON.decode((String)jsonStr, (Class)((Class)targetType));
        }
        return (T)val;
    }

    protected HttpRequest buildQueryOption(HttpRequest request, QueryOptionsBase queryOptions) {
        if (queryOptions == null) {
            return request;
        }
        if (Strings.isNotEmpty((String)queryOptions.getSelect())) {
            request.addQueryParam("select", queryOptions.getSelect());
        }
        if (Strings.isNotEmpty((String)queryOptions.getExpand())) {
            request.addQueryParam("expand", queryOptions.getExpand());
        }
        if (queryOptions instanceof QueryOptions) {
            QueryOptions qo = (QueryOptions)queryOptions;
            if (qo.getPageSize() != null) {
                request.addQueryParam("page_size", qo.getPageSize() + "");
            }
            if (qo.getPageIndex() != null) {
                request.addQueryParam("page", qo.getPageIndex() + "");
            }
            if (qo.getLimit() != null) {
                request.addQueryParam("limit", qo.getLimit() + "");
            }
            if (qo.getOffset() != null) {
                request.addQueryParam("offset", qo.getOffset() + "");
            }
            if (qo.isTotal()) {
                request.addQueryParam("total", "true");
            }
            if (Strings.isNotEmpty((String)qo.getOrderBy())) {
                request.addQueryParam("orderBy", qo.getOrderBy());
            }
            if (Strings.isNotEmpty((String)qo.getFilters())) {
                request.addQueryParam("filters", qo.getFilters());
            }
            if (Strings.isNotEmpty((String)qo.getJoins())) {
                request.addQueryParam("joins", qo.getJoins());
            }
        }
        return request;
    }
}

