/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import java.util.ArrayList;
import leap.lang.Strings;
import leap.web.api.query.Select;
import leap.web.exception.BadRequestException;

public class SelectParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Select parse(String expr) {
        String[] names;
        ArrayList<Select.Item> items = new ArrayList<Select.Item>();
        for (String name : names = Strings.split((String)expr, (char)',')) {
            Select.Item item;
            String[] parts = Strings.splitWhitespaces((String)name);
            if (parts.length > 2) throw new BadRequestException("Invalid select item '" + name + "'");
            String[] join = Strings.split((String)parts[0], (String)".");
            if (join.length == 1) {
                item = parts.length == 1 ? new Select.Item(parts[0]) : new Select.Item(parts[0], parts[1]);
            } else {
                if (join.length != 2) throw new BadRequestException("Invalid join item '" + parts[0] + "'");
                item = parts.length == 1 ? new Select.Item(join[1], null, join[0]) : new Select.Item(join[1], parts[1], join[0]);
            }
            items.add(item);
        }
        return new Select(items.toArray(new Select.Item[items.size()]));
    }
}

