/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import java.util.ArrayList;
import java.util.List;
import leap.web.api.query.OrderBy;
import leap.web.api.query.ParserBase;

public class OrderByParser
extends ParserBase {
    private List<OrderBy.Item> items = new ArrayList<OrderBy.Item>();

    public static OrderBy parse(String expr) {
        return new OrderByParser(expr).orderBy();
    }

    public OrderByParser(String expr) {
        super(expr);
    }

    public OrderBy orderBy() {
        this.nextChar();
        OrderBy.Item item = null;
        while (!this.eof()) {
            if (this.isWhitespace()) {
                this.nextChar();
                continue;
            }
            if (null == item) {
                String name = this.scanName();
                int dotIndex = name.indexOf(46);
                item = dotIndex > 0 ? new OrderBy.Item(name.substring(dotIndex + 1), name.substring(0, dotIndex)) : new OrderBy.Item(name);
                this.items.add(item);
                continue;
            }
            if (this.ch == ',') {
                item = null;
                this.nextChar();
                continue;
            }
            String s = this.scanWord();
            if (s.equalsIgnoreCase("asc")) continue;
            if (s.equalsIgnoreCase("desc")) {
                item.desc();
                continue;
            }
            this.error("Expect 'asc' or 'desc' but '" + s + "'");
        }
        return new OrderBy(this.items.toArray(new OrderBy.Item[this.items.size()]));
    }

    private String scanName() {
        this.skipWhitespaces();
        int start = this.pos;
        while (true) {
            this.nextChar();
            if (this.ch == ',' || this.isWhitespace() || this.eof()) break;
            if (this.ch == '.' || OrderByParser.isIdentifierChar((char)this.ch)) continue;
            this.error("Illegal identifier char '" + this.ch + "'");
        }
        String s = this.substring(start, this.pos);
        if (s.isEmpty()) {
            this.error("Unexpected eof");
        }
        return s;
    }

    private String scanWord() {
        this.skipWhitespaces();
        int start = this.pos;
        do {
            this.nextChar();
        } while (!this.eof() && Character.isLetter(this.ch));
        String s = this.substring(start, this.pos);
        if (s.isEmpty()) {
            this.error("Unexpected eof");
        }
        return s;
    }
}

