/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

public class OrderBy {
    private final Item[] items;

    OrderBy(Item[] items) {
        this.items = items;
    }

    public Item[] items() {
        return this.items;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.items.length; ++i) {
            Item item;
            if (i > 0) {
                s.append(',');
            }
            if (null != (item = this.items[i]).alias) {
                s.append(item.alias).append('.');
            }
            s.append(item.name);
            if (item.isAscending()) continue;
            s.append(" desc");
        }
        return s.toString();
    }

    public static final class Item {
        private String alias;
        private String name;
        private boolean ascending = true;

        public Item(String name) {
            this.name = name;
        }

        public Item(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }

        public boolean hasAlias() {
            return null != this.alias;
        }

        public String alias() {
            return this.alias;
        }

        public String name() {
            return this.name;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void asc() {
            this.ascending = true;
        }

        public void desc() {
            this.ascending = false;
        }
    }
}

