/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import java.util.ArrayList;
import java.util.List;
import leap.web.api.query.Join;
import leap.web.api.query.ParserBase;

public class JoinParser
extends ParserBase {
    private final List<Join> joins = new ArrayList<Join>();

    public static Join[] parse(String expr) {
        return new JoinParser(expr).joins();
    }

    public JoinParser(String expr) {
        super(expr);
    }

    public Join[] joins() {
        this.nextChar();
        while (!this.eof()) {
            if (this.isWhitespace()) {
                this.nextChar();
                continue;
            }
            if (this.ch == ',') {
                if (this.joins.size() == 0) {
                    this.error("Unexpected char ','");
                }
                this.nextChar();
            }
            String relation = this.scanIdentifier();
            String alias = this.scanIdentifier();
            this.joins.add(new Join(relation, alias));
        }
        return this.joins.toArray(new Join[this.joins.size()]);
    }

    private String scanIdentifier() {
        this.skipWhitespaces();
        int start = this.pos;
        while (true) {
            this.nextChar();
            if (this.ch == ',' || this.isWhitespace() || this.eof()) break;
            if (JoinParser.isIdentifierChar((char)this.ch)) continue;
            this.error("Illegal identifier char '" + this.ch + "'");
        }
        String s = "";
        if (this.pos <= this.chars.length() && this.pos > start) {
            s = this.substring(start, this.pos);
        }
        if (s.isEmpty()) {
            this.error("Unexpected eof");
        }
        return s;
    }
}

