/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import java.util.ArrayList;
import leap.lang.Strings;
import leap.web.api.query.GroupBy;
import leap.web.exception.BadRequestException;

public class GroupByParser {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupBy parse(String expr) {
        String[] names;
        ArrayList<GroupBy.Item> items = new ArrayList<GroupBy.Item>();
        for (String name : names = Strings.split((String)expr, (char)',')) {
            GroupBy.Item item;
            String[] parts = Strings.splitWhitespaces((String)name);
            if (parts.length > 2) throw new BadRequestException("Invalid select item '" + name + "'");
            String[] join = Strings.split((String)parts[0], (String)".");
            if (join.length == 1) {
                item = parts.length == 1 ? new GroupBy.Item(parts[0]) : new GroupBy.Item(parts[0], parts[1]);
            } else {
                if (join.length != 2) throw new BadRequestException("Invalid join item '" + parts[0] + "'");
                item = parts.length == 1 ? new GroupBy.Item(join[1], null, join[0]) : new GroupBy.Item(join[1], parts[1], join[0]);
            }
            items.add(item);
        }
        return new GroupBy(items.toArray(new GroupBy.Item[items.size()]));
    }
}

