/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import leap.lang.Strings;

public class GroupBy {
    private final Item[] items;

    GroupBy(Item[] items) {
        this.items = items;
    }

    public Item[] items() {
        return this.items;
    }

    public boolean aliasContain(String expr) {
        for (Item item : this.items) {
            if (!Strings.isNotEmpty((String)item.alias) || !item.alias().equals(expr)) continue;
            return true;
        }
        return false;
    }

    public static final class Item {
        private String joinAlias;
        private String name;
        private String alias;

        public Item(String name) {
            this.name = name;
        }

        public Item(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }

        public Item(String name, String alias, String joinAlias) {
            this.joinAlias = joinAlias;
            this.name = name;
            this.alias = alias;
        }

        public String joinAlias() {
            return this.joinAlias;
        }

        public String name() {
            return this.name;
        }

        public String alias() {
            return this.alias;
        }
    }
}

