/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import java.util.ArrayList;
import leap.lang.Strings;
import leap.web.api.query.Expand;
import leap.web.exception.BadRequestException;

public class ExpandParser {
    private static final Expand[] EMPTY_ARRAY = new Expand[0];

    public static Expand[] parse(String expr) {
        if (Strings.isEmpty((String)expr)) {
            return EMPTY_ARRAY;
        }
        ArrayList<Expand> list = new ArrayList<Expand>();
        char[] chars = expr.toCharArray();
        int start = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case ',': {
                    list.add(new Expand(expr.substring(start, i).trim()));
                    start = i + 1;
                    continue block4;
                }
                case '(': {
                    int index = expr.indexOf(41, i);
                    if (index < 0) {
                        throw new BadRequestException("Invalid expand : " + expr);
                    }
                    String name = expr.substring(start, i).trim();
                    String select = expr.substring(i + 1, index);
                    list.add(new Expand(name, select));
                    for (i = index + 1; i < chars.length; ++i) {
                        char c1 = chars[i];
                        if (Character.isWhitespace(c1)) continue;
                        if (c1 == ',') break;
                        throw new BadRequestException("Invalid expand : " + expr);
                    }
                    start = ++i;
                }
            }
        }
        if (start == 0) {
            list.add(new Expand(expr.trim()));
        } else if (start < chars.length - 1) {
            list.add(new Expand(expr.substring(start).trim()));
        }
        return list.toArray(EMPTY_ARRAY);
    }
}

