/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import leap.lang.Strings;
import leap.web.api.query.Aggregate;
import leap.web.exception.BadRequestException;

public class AggregateParser {
    private static final Set<String> funcs = new HashSet<String>();
    private static final boolean[] identifierFlags;

    public static Aggregate parse(String expr, Boolean allowSingleExpr) {
        return AggregateParser.processParse(expr, allowSingleExpr);
    }

    public static Aggregate parse(String expr) {
        return AggregateParser.processParse(expr, false);
    }

    private static Aggregate processParse(String expr, Boolean allowSingleExpr) {
        ArrayList<Aggregate.Item> items = new ArrayList<Aggregate.Item>();
        if (!Strings.isEmpty((String)expr)) {
            String[] parts;
            for (String part : parts = Strings.split((String)expr, (char)',')) {
                String func;
                Aggregate.Item item;
                int index0 = part.indexOf(40);
                if (!allowSingleExpr.booleanValue() && index0 <= 0) {
                    AggregateParser.invalidExpr(expr);
                } else if (allowSingleExpr.booleanValue() && index0 <= 0) {
                    item = new Aggregate.Item(part, null, null);
                    items.add(item);
                    continue;
                }
                int index1 = part.indexOf(41, index0);
                if (index1 <= index0) {
                    AggregateParser.invalidExpr(expr);
                }
                if (!funcs.contains((func = part.substring(0, index0)).toLowerCase())) {
                    throw new BadRequestException("Unsupported aggregation function '" + func + "'");
                }
                String name = part.substring(index0 + 1, index1).trim();
                if (Strings.isEmpty((String)name)) {
                    AggregateParser.invalidExpr(expr);
                }
                if (func.equalsIgnoreCase("count") && !"*".equals(name)) {
                    throw new BadRequestException("Expected 'count(*)', actual '" + func + "(" + name + ")'");
                }
                String rest = index1 == part.length() - 1 ? "" : part.substring(index1 + 1).trim();
                String alias = AggregateParser.alias(rest, name, func);
                item = new Aggregate.Item(name, func, alias);
                items.add(item);
            }
        }
        return new Aggregate(items.toArray(new Aggregate.Item[items.size()]));
    }

    private static String alias(String rest, String field, String func) {
        String alias;
        if (Strings.isEmpty((String)rest)) {
            if ("count".equalsIgnoreCase(func)) {
                return "total";
            }
            alias = Strings.lowerCamel((String[])new String[]{field, func});
        } else {
            alias = Strings.removeStartIgnoreCase((String)rest, (String)"as ").trim();
        }
        if (!AggregateParser.isIdentifier(alias)) {
            throw new BadRequestException("Invalid alias '" + alias + "', must be identifier");
        }
        return alias;
    }

    private static void invalidExpr(String expr) {
        throw new BadRequestException("Invalid aggregates expr '" + expr + "'");
    }

    private static boolean isIdentifier(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (AggregateParser.isIdentifierChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifierChar(char c) {
        return c > identifierFlags.length || identifierFlags[c];
    }

    static {
        funcs.add("sum");
        funcs.add("avg");
        funcs.add("min");
        funcs.add("max");
        funcs.add("count");
        identifierFlags = new boolean[256];
        for (int c = 0; c < identifierFlags.length; c = (int)((char)(c + 1))) {
            if (c >= 65 && c <= 90) {
                AggregateParser.identifierFlags[c] = true;
                continue;
            }
            if (c >= 97 && c <= 122) {
                AggregateParser.identifierFlags[c] = true;
                continue;
            }
            if (c < 48 || c > 57) continue;
            AggregateParser.identifierFlags[c] = true;
        }
        AggregateParser.identifierFlags[95] = true;
        AggregateParser.identifierFlags[36] = true;
    }
}

