/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.query;

import leap.lang.Strings;

public class Aggregate {
    private final Item[] items;

    Aggregate(Item[] items) {
        this.items = items;
    }

    public Item[] items() {
        return this.items;
    }

    public boolean aliasContain(String expr) {
        for (Item item : this.items) {
            if (!Strings.isNotEmpty((String)item.alias) || !item.alias().equals(expr)) continue;
            return true;
        }
        return false;
    }

    public static final class Item {
        private String name;
        private String function;
        private String alias;

        public Item(String name, String function, String alias) {
            this.name = name;
            this.function = function;
            this.alias = alias;
        }

        public String name() {
            return this.name;
        }

        public String function() {
            return this.function;
        }

        public String alias() {
            return this.alias;
        }
    }
}

