/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.permission;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import leap.lang.Args;
import leap.web.api.permission.ResourcePermissions;

public class ResourcePermissionsSet {
    private final Set<ResourcePermissions> allResourcePermissions = new LinkedHashSet<ResourcePermissions>();
    private final Map<String, ResourcePermissions> resourceClassPermissions = new HashMap<String, ResourcePermissions>();
    private final Map<String, ResourcePermissions> resourcePackagePermissions = new HashMap<String, ResourcePermissions>();

    public Set<ResourcePermissions> getAllResourcePermissions() {
        return this.allResourcePermissions;
    }

    public ResourcePermissions tryGetResourcePermissions(Class<?> resourceClass) {
        ResourcePermissions rps = this.resourceClassPermissions.get(resourceClass);
        if (null != rps) {
            return rps;
        }
        for (Map.Entry<String, ResourcePermissions> entry : this.resourcePackagePermissions.entrySet()) {
            if (!resourceClass.getName().startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public void addResourcePermissions(ResourcePermissions rps) {
        Args.notNull((Object)rps);
        rps.getResourceClasses().forEach(c -> {
            if (this.resourceClassPermissions.containsKey(c)) {
                throw new IllegalStateException("Duplicate permissions definition of resource class '" + c + "'");
            }
            this.resourceClassPermissions.put((String)c, rps);
        });
        rps.getResourcePackages().forEach(p -> {
            if (!p.endsWith(".")) {
                p = p + ".";
            }
            if (this.resourcePackagePermissions.containsKey(p)) {
                throw new IllegalStateException("Duplicate permissions definition of resource package '" + p + "'");
            }
            this.resourcePackagePermissions.put((String)p, rps);
        });
        this.allResourcePermissions.add(rps);
    }
}

