/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import leap.lang.New;
import leap.lang.el.spel.SPEL;
import leap.web.api.meta.model.MApiPermission;
import leap.web.api.permission.ResourcePermission;
import leap.web.route.Route;

public class ResourcePermissions {
    private final Set<String> resourceClasses = new HashSet<String>();
    private final Set<String> resourcePackages = new HashSet<String>();
    private final Set<ResourcePermission> permissions = new TreeSet<ResourcePermission>(ResourcePermission.COMPARATOR);
    private ResourcePermission defaultPermission;

    public Set<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public Set<String> getResourcePackages() {
        return this.resourcePackages;
    }

    public Set<ResourcePermission> getPermissions() {
        return this.permissions;
    }

    public ResourcePermission getDefaultPermission() {
        return this.defaultPermission;
    }

    public void setDefaultPermission(ResourcePermission defaultPermission) {
        this.defaultPermission = defaultPermission;
    }

    public void addResourceClass(String clzzName) {
        this.resourceClasses.add(clzzName);
    }

    public void addResourcePackage(String p) {
        this.resourcePackages.add(p);
    }

    public void addPermission(ResourcePermission p) {
        if (p.isDefault()) {
            if (null != this.defaultPermission) {
                throw new IllegalStateException("Duplicated default permission '" + p.getValue() + "'");
            }
            this.defaultPermission = p;
        }
        this.permissions.add(p);
    }

    public MApiPermission[] resolvePermissions(Route route, Class<?> resourceType) {
        ArrayList list = New.arrayList();
        String resourceName = resourceType.getSimpleName();
        HashMap vars = New.hashMap((Object)"resource", (Object)resourceName);
        this.permissions.forEach(p -> {
            if (p.matches(route)) {
                String value = this.eval(p.getValue(), vars);
                String desc = this.eval(p.getDescription(), vars);
                list.add(new MApiPermission(value, desc));
            }
        });
        if (list.isEmpty() && null != this.defaultPermission) {
            list.add(new MApiPermission(this.defaultPermission.getValue(), this.defaultPermission.getDescription()));
        }
        return list.toArray(new MApiPermission[0]);
    }

    protected String eval(String value, Map<String, Object> vars) {
        return (String)SPEL.createCompositeExpression((String)value).getValue(vars);
    }
}

