/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.List;
import leap.core.value.Record;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.QueryOneResult;
import leap.web.api.orm.RelationExecutionContext;
import leap.web.api.orm.RelationQueryInterceptor;

public class RelationQueryExtension
implements RelationQueryInterceptor {
    static RelationQueryExtension EMPTY = new RelationQueryExtension(null);
    protected final RelationQueryInterceptor[] interceptors;

    public RelationQueryExtension(RelationQueryInterceptor[] interceptors) {
        this.interceptors = null == interceptors ? new RelationQueryInterceptor[]{} : interceptors;
    }

    @Override
    public boolean preRelateQueryOne(RelationExecutionContext context, Object relatedId, QueryOptionsBase options) {
        for (RelationQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preRelateQueryOne(context, relatedId, options)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean postRelateQueryOne(RelationExecutionContext context, Object relatedId, Record record) {
        for (RelationQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.postRelateQueryOne(context, relatedId, record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean completeRelateQueryOne(RelationExecutionContext context, Object relatedId, QueryOneResult result) {
        for (RelationQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.completeRelateQueryOne(context, relatedId, result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preRelateQueryList(RelationExecutionContext context, Object relatedId, QueryOptions options) {
        for (RelationQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preRelateQueryList(context, relatedId, options)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean postRelateQueryList(RelationExecutionContext context, Object relatedId, List<Record> records) {
        for (RelationQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.postRelateQueryList(context, relatedId, records)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean completeRelateQueryList(RelationExecutionContext context, Object relatedId, QueryListResult result) {
        for (RelationQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.completeRelateQueryList(context, relatedId, result)) continue;
            return true;
        }
        return false;
    }
}

