/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.Map;
import java.util.Set;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.web.api.orm.ModelExecutionContext;
import leap.web.api.orm.ModelReplaceInterceptor;
import leap.web.api.orm.ModelUpdateHandler;
import leap.web.api.orm.ModelUpdateInterceptor;
import leap.web.api.orm.UpdateOneResult;

public class ModelUpdateExtension
implements ModelUpdateInterceptor,
ModelReplaceInterceptor {
    private static final Log log = LogFactory.get(ModelUpdateExtension.class);
    static ModelUpdateExtension EMPTY = new ModelUpdateExtension(null, null, null);
    protected final ModelUpdateHandler handler;
    protected final ModelUpdateInterceptor[] updateInterceptors;
    protected final ModelReplaceInterceptor[] replaceInterceptors;

    public ModelUpdateExtension(ModelUpdateHandler handler, ModelUpdateInterceptor[] updateInterceptors, ModelReplaceInterceptor[] replaceInterceptors) {
        this.handler = handler;
        this.updateInterceptors = null == updateInterceptors ? new ModelUpdateInterceptor[]{} : updateInterceptors;
        this.replaceInterceptors = null == replaceInterceptors ? new ModelReplaceInterceptor[]{} : replaceInterceptors;
    }

    public ModelUpdateHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean processUpdateProperties(ModelExecutionContext context, Object id, Map<String, Object> properties) {
        for (ModelUpdateInterceptor interceptor : this.updateInterceptors) {
            if (!interceptor.processUpdateProperties(context, id, properties)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleUpdatePropertyNotFound(ModelExecutionContext context, String name, Object value, Set<String> removes) {
        for (ModelUpdateInterceptor interceptor : this.updateInterceptors) {
            if (!interceptor.handleUpdatePropertyNotFound(context, name, value, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleUpdatePropertyReadonly(ModelExecutionContext context, String name, Object value, Set<String> removes) {
        for (ModelUpdateInterceptor interceptor : this.updateInterceptors) {
            if (!interceptor.handleUpdatePropertyReadonly(context, name, value, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preUpdate(ModelExecutionContext context, Object id, Map<String, Object> properties) {
        for (ModelUpdateInterceptor interceptor : this.updateInterceptors) {
            if (!interceptor.preUpdate(context, id, properties)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object postUpdateProperties(ModelExecutionContext context, Object id, int affected) {
        for (ModelUpdateInterceptor interceptor : this.updateInterceptors) {
            Object v = interceptor.postUpdateProperties(context, id, affected);
            if (null == v) continue;
            return v;
        }
        return null;
    }

    @Override
    public void completeUpdate(ModelExecutionContext context, UpdateOneResult result, Throwable e) {
        for (ModelUpdateInterceptor interceptor : this.updateInterceptors) {
            try {
                interceptor.completeUpdate(context, result, e);
            }
            catch (Throwable ex) {
                log.error("Err exec {}#completeUpdate", new Object[]{interceptor, ex});
            }
        }
    }

    @Override
    public boolean processReplaceRecord(ModelExecutionContext context, Object id, Map<String, Object> record) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            if (!interceptor.processReplaceRecord(context, id, record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processReplaceNONEProperties(ModelExecutionContext context, Object id, Map<String, Object> record, Set<String> removes) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            if (!interceptor.processReplaceNONEProperties(context, id, record, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleReplacePropertyNotFound(ModelExecutionContext context, String name, Object value, Set<String> removes) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            if (!interceptor.handleReplacePropertyNotFound(context, name, value, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleReplacePropertyReadonly(ModelExecutionContext context, String name, Object value, Set<String> removes) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            if (!interceptor.handleReplacePropertyReadonly(context, name, value, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preReplace(ModelExecutionContext context, Object id, Map<String, Object> record) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            if (!interceptor.preReplace(context, id, record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object postReplaceRecord(ModelExecutionContext context, Object id, int affected) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            Object v = interceptor.postReplaceRecord(context, id, affected);
            if (null == v) continue;
            return v;
        }
        return null;
    }

    @Override
    public void completeReplace(ModelExecutionContext context, UpdateOneResult result, Throwable e) {
        for (ModelReplaceInterceptor interceptor : this.replaceInterceptors) {
            try {
                interceptor.completeReplace(context, result, e);
            }
            catch (Throwable ex) {
                log.error("Err exec {}#completeReplace", new Object[]{interceptor, ex});
            }
        }
    }
}

