/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.List;
import leap.core.value.Record;
import leap.lang.jdbc.WhereBuilder;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.orm.query.CriteriaQuery;
import leap.orm.query.PageResult;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.orm.ModelExecutionContext;
import leap.web.api.orm.ModelQueryHandler;
import leap.web.api.orm.ModelQueryInterceptor;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.QueryOneResult;

public class ModelQueryExtension
implements ModelQueryInterceptor {
    private static final Log log = LogFactory.get(ModelQueryExtension.class);
    public static final ModelQueryExtension EMPTY = new ModelQueryExtension(null, null);
    protected final ModelQueryHandler handler;
    protected final ModelQueryInterceptor[] interceptors;

    public ModelQueryExtension(ModelQueryHandler handler, ModelQueryInterceptor[] interceptors) {
        this.handler = handler;
        this.interceptors = null == interceptors ? new ModelQueryInterceptor[]{} : interceptors;
    }

    public ModelQueryHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean processQueryOneOptions(ModelExecutionContext context, QueryOptionsBase options) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.processQueryOneOptions(context, options)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preQueryOne(ModelExecutionContext context) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preQueryOne(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preQueryOne(ModelExecutionContext context, Object id, CriteriaQuery query) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preQueryOne(context, id, query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object processQueryOneRecord(ModelExecutionContext context, Object id, Record record) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            Object v = interceptor.processQueryOneRecord(context, id, record);
            if (null == v) continue;
            return v;
        }
        return null;
    }

    @Override
    public void completeQueryOne(ModelExecutionContext context, QueryOneResult result, Throwable e) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            try {
                interceptor.completeQueryOne(context, result, e);
            }
            catch (Throwable ex) {
                log.error("Err exec {}#completeQueryOne", new Object[]{interceptor, ex});
            }
        }
    }

    @Override
    public boolean processQueryListOptions(ModelExecutionContext context, QueryOptions options) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.processQueryListOptions(context, options)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preProcessQueryListWhere(ModelExecutionContext context, QueryOptions options, WhereBuilder where) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preProcessQueryListWhere(context, options, where)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean postProcessQueryListWhere(ModelExecutionContext context, QueryOptions options, WhereBuilder where) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.postProcessQueryListWhere(context, options, where)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preQueryList(ModelExecutionContext context, CriteriaQuery query) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preQueryList(context, query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Record> executeQueryList(ModelExecutionContext context, QueryOptions options, CriteriaQuery<Record> query) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            List<Record> list = interceptor.executeQueryList(context, options, query);
            if (null == list) continue;
            return list;
        }
        return null;
    }

    @Override
    public Object processQueryListResult(ModelExecutionContext context, PageResult page, long totalCount, List<Record> records) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            Object v = interceptor.processQueryListResult(context, page, totalCount, records);
            if (null == v) continue;
            return v;
        }
        return null;
    }

    @Override
    public void completeQueryList(ModelExecutionContext context, QueryListResult result, Throwable e) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            try {
                interceptor.completeQueryList(context, result, e);
            }
            catch (Throwable ex) {
                log.error("Err exec {}#completeQueryList", new Object[]{interceptor, ex});
            }
        }
    }

    @Override
    public boolean preCount(ModelExecutionContext context, CriteriaQuery query) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            if (!interceptor.preCount(context, query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void preExpand(ModelExecutionContext context) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            interceptor.preExpand(context);
        }
    }

    @Override
    public void preExpand(ModelExecutionContext context, CriteriaQuery<Record> query) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            interceptor.preExpand(context, query);
        }
    }

    @Override
    public void completeExpand(ModelExecutionContext context) {
        for (ModelQueryInterceptor interceptor : this.interceptors) {
            try {
                interceptor.completeExpand(context);
            }
            catch (Throwable ex) {
                log.error("Err exec {}#completeExpand", new Object[]{interceptor, ex});
            }
        }
    }
}

