/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.Map;
import java.util.Set;
import leap.core.value.Record;
import leap.web.api.orm.ModelCreateHandler;
import leap.web.api.orm.ModelCreateInterceptor;
import leap.web.api.orm.ModelExecutionContext;

public class ModelCreateExtension
implements ModelCreateInterceptor {
    static ModelCreateExtension EMPTY = new ModelCreateExtension(null, null);
    protected final ModelCreateHandler handler;
    protected final ModelCreateInterceptor[] interceptors;

    public ModelCreateExtension(ModelCreateHandler handler, ModelCreateInterceptor[] interceptors) {
        this.handler = handler;
        this.interceptors = null == interceptors ? new ModelCreateInterceptor[]{} : interceptors;
    }

    public ModelCreateHandler getHandler() {
        return this.handler;
    }

    @Override
    public Object processCreationParams(ModelExecutionContext context, Object params) {
        for (ModelCreateInterceptor interceptor : this.interceptors) {
            Object v = interceptor.processCreationParams(context, params);
            if (null == v) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean processCreationRecord(ModelExecutionContext context, Map<String, Object> record) {
        for (ModelCreateInterceptor interceptor : this.interceptors) {
            if (!interceptor.processCreationRecord(context, record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleCreationPropertyNotFound(ModelExecutionContext context, String name, Object value, Set<String> removes) {
        for (ModelCreateInterceptor interceptor : this.interceptors) {
            if (!interceptor.handleCreationPropertyNotFound(context, name, value, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleCreationPropertyReadonly(ModelExecutionContext context, String name, Object value, Set<String> removes) {
        for (ModelCreateInterceptor interceptor : this.interceptors) {
            if (!interceptor.handleCreationPropertyReadonly(context, name, value, removes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean preCreateRecord(ModelExecutionContext context, Map<String, Object> record) {
        for (ModelCreateInterceptor interceptor : this.interceptors) {
            if (!interceptor.preCreateRecord(context, record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object postCreateRecord(ModelExecutionContext context, Object id, Record record) {
        for (ModelCreateInterceptor interceptor : this.interceptors) {
            Object v = interceptor.postCreateRecord(context, id, record);
            if (null == v) continue;
            return v;
        }
        return null;
    }
}

