/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import leap.core.value.Record;
import leap.lang.Strings;
import leap.orm.mapping.EntityMapping;
import leap.orm.mapping.RelationMapping;
import leap.orm.mapping.RelationType;
import leap.orm.query.CriteriaQuery;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.orm.DefaultModelQueryExecutor;
import leap.web.api.orm.DefaultRelationExecutionContext;
import leap.web.api.orm.ExpandError;
import leap.web.api.orm.ModelExecutionContext;
import leap.web.api.orm.ModelExecutorBase;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.QueryOneResult;
import leap.web.api.orm.RelationExecutorContext;
import leap.web.api.orm.RelationQueryExecutor;
import leap.web.api.orm.RelationQueryExtension;
import leap.web.api.remote.RestQueryListResult;
import leap.web.api.remote.RestResource;
import leap.web.api.restd.CrudUtils;
import leap.web.exception.BadRequestException;

public class DefaultRelationQueryExecutor
extends ModelExecutorBase<RelationExecutorContext>
implements RelationQueryExecutor {
    protected final RelationQueryExtension ex;
    protected final EntityMapping tem;
    protected final RelationMapping rm;
    protected final String rp;
    protected final RelationMapping irm;
    protected final InverseQueryExecutor iqe;

    public DefaultRelationQueryExecutor(RelationExecutorContext context, RelationQueryExtension ex) {
        super(context);
        this.ex = ex;
        this.tem = context.getInverseEntityMapping();
        this.rm = context.getRelation();
        this.rp = !Strings.isEmpty((String)context.getRelationPath()) ? context.getRelationPath() : Strings.lowerUnderscore((String)this.rm.getName());
        this.irm = context.getInverseRelation();
        this.iqe = new InverseQueryExecutor(context.newInverseExecutorContext(), this.irm);
    }

    @Override
    public QueryOneResult queryOne(Object id, QueryOptionsBase options) {
        Record record;
        if (!this.rm.isManyToOne()) {
            throw new IllegalStateException("Relation '" + this.rm.getName() + "' must be " + RelationType.MANY_TO_ONE + "' for query one");
        }
        DefaultRelationExecutionContext context = new DefaultRelationExecutionContext((RelationExecutorContext)this.context);
        this.ex.preRelateQueryOne(context, id, options);
        ArrayList<ExpandError> expandErrors = null;
        if (this.remoteRest) {
            record = this.queryOneRemoteSource(id, options);
        } else if (this.tem.isRemoteRest()) {
            record = this.queryOneRemoteTarget(id, options);
        } else {
            expandErrors = new ArrayList<ExpandError>();
            record = this.iqe.queryOneByRelation(context, id, options, expandErrors);
        }
        this.ex.postRelateQueryOne(context, id, record);
        QueryOneResult result = new QueryOneResult(record, expandErrors);
        this.ex.completeRelateQueryOne(context, id, result);
        return result;
    }

    protected Record queryOneRemoteSource(Object id, QueryOptionsBase options) {
        RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
        return restResource.findRelationOne(this.rp, id, options);
    }

    protected Record queryOneRemoteTarget(Object id, QueryOptionsBase options) {
        String[] fields = (String[])Arrays.stream(this.rm.getJoinFields()).map(joinField -> joinField.getLocalFieldName()).toArray(String[]::new);
        Record record = (Record)this.dao.createCriteriaQuery(this.em).select(fields).whereById(id).firstOrNull();
        if (null == record) {
            throw new BadRequestException("Record " + this.em.getEntityName() + "(" + id + ") not found");
        }
        Object targetId = CrudUtils.getSingleOrMap((Map<String, Object>)record, fields);
        if (null == targetId) {
            return null;
        }
        return this.iqe.queryOne((Object)targetId, (QueryOptionsBase)options).record;
    }

    @Override
    public QueryListResult queryList(Object id, QueryOptions options) {
        DefaultRelationExecutionContext context = new DefaultRelationExecutionContext((RelationExecutorContext)this.context);
        this.ex.preRelateQueryList(context, id, options);
        QueryListResult result = this.remoteRest ? this.queryListRemoteSource(id, options) : (this.rm.isEmbedded() ? this.queryListEmbedded(id, options) : (this.tem.isRemoteRest() ? this.queryListRemoteTarget(id, options) : this.iqe.queryListByRelation(id, options)));
        this.ex.postRelateQueryList(context, id, result.getList());
        this.ex.completeRelateQueryList(context, id, result);
        return result;
    }

    protected QueryListResult queryListEmbedded(Object id, QueryOptions options) {
        Record record = (Record)this.dao.createCriteriaQuery(this.em).whereById(id).select(new String[]{this.rm.getEmbeddedFileName()}).firstOrNull();
        if (null == record) {
            throw new BadRequestException("Record " + this.em.getEntityName() + "(" + id + ") not found");
        }
        HashSet<Object> embeddedIds = new HashSet<Object>();
        this.iqe.calcIdsByEmbeddedField(embeddedIds, record, this.rm.getEmbeddedFileName());
        if (embeddedIds.isEmpty()) {
            return QueryListResult.EMPTY;
        }
        return this.iqe.queryListByIds(embeddedIds, options);
    }

    protected QueryListResult queryListRemoteSource(Object id, QueryOptions options) {
        RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
        RestQueryListResult<Record> result = restResource.queryRelationList(this.rp, id, options);
        return new QueryListResult(result.getList(), result.getCount());
    }

    protected QueryListResult queryListRemoteTarget(Object id, QueryOptions options) {
        throw new IllegalStateException("queryListRemoteTarget not implemented");
    }

    protected static class InverseQueryExecutor
    extends DefaultModelQueryExecutor {
        private final RelationMapping rm;

        public InverseQueryExecutor(ModelExecutorContext context, RelationMapping rm) {
            super(context);
            this.rm = rm;
        }

        public Record queryOneByRelation(ModelExecutionContext context, Object relatedId, QueryOptionsBase options, List<ExpandError> expandErrors) {
            CriteriaQuery query = this.createCriteriaQuery().joinById(this.rm.getTargetEntityName(), this.rm.getName(), "j", relatedId);
            DefaultModelQueryExecutor.JoinModels joinModels = new DefaultModelQueryExecutor.JoinModels("j", new DefaultModelQueryExecutor.ModelAndMapping(this.am, this.em));
            this.applySelect(query, options, joinModels);
            Record record = (Record)query.firstOrNull();
            List<ExpandError> ees = this.expandOne(context, record, options);
            if (null != ees) {
                expandErrors.addAll(ees);
            }
            return record;
        }

        public QueryListResult queryListByRelation(Object relatedId, QueryOptions options) {
            CriteriaQuery query = this.createCriteriaQuery().joinById(this.rm.getTargetEntityName(), this.rm.getName(), "j", relatedId);
            DefaultModelQueryExecutor.JoinModels joinModels = new DefaultModelQueryExecutor.JoinModels("j", new DefaultModelQueryExecutor.ModelAndMapping(this.am, this.em));
            return this.doQueryListResult((CriteriaQuery<Record>)query, joinModels, options, null, null);
        }

        public QueryListResult queryListByIds(Set<Object> ids, QueryOptions options) {
            String idFieldName = this.em.getKeyFieldNames()[0];
            if (this.remoteRest) {
                String filter = idFieldName + " in (" + this.joinInIds(new ArrayList<Object>(ids)) + ")";
                if (Strings.isEmpty((String)options.getFilters())) {
                    options.setFilters(filter);
                } else {
                    options.setFilters("(" + options.getFilters() + ") and (" + filter + ")");
                }
                RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
                RestQueryListResult<Record> result = restResource.queryList(options);
                return new QueryListResult(result.getList(), result.getCount());
            }
            CriteriaQuery query = this.createCriteriaQuery().where(idFieldName + " in ?", new Object[]{ids});
            return this.doQueryListResult((CriteriaQuery<Record>)query, new DefaultModelQueryExecutor.JoinModels(), options, null, null);
        }
    }
}

