/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import leap.core.validation.Errors;
import leap.core.validation.ValidationException;
import leap.lang.Enumerable;
import leap.lang.Enumerables;
import leap.lang.New;
import leap.orm.command.UpdateCommand;
import leap.orm.event.EntityListeners;
import leap.orm.mapping.EntityMapping;
import leap.orm.mapping.FieldMapping;
import leap.orm.mapping.RelationMapping;
import leap.orm.mapping.RelationProperty;
import leap.web.api.meta.model.MApiProperty;
import leap.web.api.mvc.params.Partial;
import leap.web.api.orm.DefaultModelExecutionContext;
import leap.web.api.orm.ModelExecutionContext;
import leap.web.api.orm.ModelExecutorBase;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelUpdateExecutor;
import leap.web.api.orm.ModelUpdateExtension;
import leap.web.api.orm.UpdateOneResult;
import leap.web.api.remote.RestResource;
import leap.web.exception.BadRequestException;

public class DefaultModelUpdateExecutor
extends ModelExecutorBase
implements ModelUpdateExecutor {
    protected final ModelUpdateExtension ex;
    private ModelUpdateExecutor.UpdateHandler handler;
    private EntityListeners listeners;

    public DefaultModelUpdateExecutor(ModelExecutorContext context, ModelUpdateExtension ex) {
        super(context);
        this.ex = null == ex ? ModelUpdateExtension.EMPTY : ex;
    }

    @Override
    public ModelUpdateExecutor withHandler(ModelUpdateExecutor.UpdateHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public ModelUpdateExecutor withListeners(EntityListeners listeners) {
        this.listeners = listeners;
        return this;
    }

    @Override
    public UpdateOneResult replaceUpdateOne(Object id, Map<String, Object> record) {
        HashSet<String> removes;
        if (null == record || record.isEmpty()) {
            throw new BadRequestException("No update properties");
        }
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        this.ex.processReplaceRecord(context, id, record);
        if (null != this.ex.handler) {
            this.ex.handler.processReplaceRecord(context, id, record);
        }
        if (!this.ex.processReplaceNONEProperties(context, id, record, removes = new HashSet<String>())) {
            for (FieldMapping fm : this.em.getFieldMappings()) {
                if (!fm.isUpdate()) continue;
                if (!record.containsKey(fm.getFieldName())) {
                    if (fm.isNullable()) {
                        record.put(fm.getFieldName(), null);
                        continue;
                    }
                    if (null != fm.getDefaultValue()) {
                        record.put(fm.getFieldName(), fm.getDefaultValue().getValue());
                        continue;
                    }
                    throw new BadRequestException("Property '" + fm.getFieldName() + "' is required!");
                }
                Object value = record.get(fm.getFieldName());
                if (null != value || fm.isNullable()) continue;
                if (null != fm.getDefaultValue()) {
                    record.put(fm.getFieldName(), fm.getDefaultValue().getValue());
                    continue;
                }
                throw new BadRequestException("Property '" + fm.getFieldName() + "' is required, but null!");
            }
        }
        removes.forEach(record::remove);
        try {
            this.ex.preReplace(context, id, record);
            int affected = (Integer)EntityMapping.withContextListeners((EntityListeners)this.listeners, () -> this.doUpdate(context, id, record, false));
            Object entity = this.ex.postReplaceRecord(context, id, affected);
            UpdateOneResult result = new UpdateOneResult(affected, entity);
            this.ex.completeReplace(context, result, null);
            return result;
        }
        catch (Throwable e) {
            this.ex.completeReplace(context, null, e);
            throw e;
        }
    }

    @Override
    public UpdateOneResult partialUpdateOne(Object id, Partial partial) {
        if (null == partial || partial.isEmpty()) {
            throw new BadRequestException("No update properties");
        }
        return this.partialUpdateOne(id, partial.getProperties());
    }

    @Override
    public UpdateOneResult partialUpdateOne(Object id, Map<String, Object> properties) {
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        this.ex.processUpdateProperties(context, id, properties);
        if (null != this.ex.handler) {
            this.ex.handler.processUpdateProperties(context, id, properties);
        }
        try {
            RestResource restResource;
            this.ex.preUpdate(context, id, properties);
            int affected = !this.em.isRemoteRest() ? (Integer)EntityMapping.withContextListeners((EntityListeners)this.listeners, () -> {
                if (null != this.handler) {
                    return this.handler.partialUpdate(context, id, properties);
                }
                return this.doUpdate(context, id, properties, true);
            }) : ((restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em)).update(id, properties) ? 1 : 0);
            Object entity = this.ex.postUpdateProperties(context, id, affected);
            UpdateOneResult result = new UpdateOneResult(affected, entity);
            this.ex.completeUpdate(context, result, null);
            return result;
        }
        catch (Throwable e) {
            this.ex.completeUpdate(context, null, e);
            throw e;
        }
    }

    protected int doUpdate(ModelExecutionContext context, Object id, Map<String, Object> properties, boolean partial) {
        LinkedHashMap<RelationProperty, Object[]> relationProperties = new LinkedHashMap<RelationProperty, Object[]>();
        HashSet<String> removes = new HashSet<String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = entry.getKey();
            MApiProperty p = this.am.tryGetProperty(name);
            if (null == p) {
                if (partial ? this.ex.handleUpdatePropertyNotFound(context, name, entry.getValue(), removes) : this.ex.handleReplacePropertyNotFound(context, name, entry.getValue(), removes)) continue;
                throw new BadRequestException("Property '" + name + "' not exists!");
            }
            if (p.isNotUpdatableExplicitly()) {
                if (partial) {
                    if (this.ex.handleUpdatePropertyReadonly(context, name, entry.getValue(), removes)) continue;
                    throw new BadRequestException("Property '" + name + "' is not updatable!");
                }
                if (this.ex.handleReplacePropertyReadonly(context, name, entry.getValue(), removes)) continue;
                removes.add(name);
            }
            if (null != p.getMetaProperty() && p.getMetaProperty().isReference()) {
                Object v = properties.get(name);
                if (null == v) continue;
                RelationProperty rp = this.em.getRelationProperty(name);
                Enumerable e = Enumerables.tryOf((Object)v);
                if (null == e) {
                    relationProperties.put(rp, new Object[]{v});
                    continue;
                }
                relationProperties.put(rp, e.toArray());
                continue;
            }
            this.tryHandleSpecialValue(entry, p);
        }
        Errors errors = this.dao.validate(this.em, properties, properties.keySet());
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
        if (!removes.isEmpty()) {
            removes.forEach(properties::remove);
        }
        if (null != this.ex.handler) {
            this.ex.handler.preUpdateProperties(context, id, properties);
        }
        if (properties.isEmpty()) {
            throw new BadRequestException("No update properties");
        }
        UpdateCommand update = this.dao.cmdUpdate(this.em.getEntityName()).withId(id).from(properties);
        AtomicInteger result = new AtomicInteger();
        if (relationProperties.isEmpty()) {
            result.set(this.executeUpdate(update, id));
        } else {
            this.dao.doTransaction(conn -> {
                result.set(this.executeUpdate(update, id));
                if (result.get() > 0) {
                    for (Map.Entry entry : relationProperties.entrySet()) {
                        String targetName;
                        String localName;
                        RelationProperty rp = (RelationProperty)entry.getKey();
                        RelationMapping rm = this.em.getRelationMapping(rp.getRelationName());
                        if (!rm.isManyToMany()) continue;
                        EntityMapping joinEntity = this.md.getEntityMapping(rm.getJoinEntityName());
                        RelationMapping manyToOne1 = joinEntity.tryGetKeyRelationMappingOfTargetEntity(this.em.getEntityName());
                        String joinIdFieldName1 = manyToOne1.getJoinFields()[0].getLocalFieldName();
                        if (joinEntity.getKeyFieldMappings()[0].getFieldName().equals(manyToOne1.getJoinFields()[0].getLocalFieldName())) {
                            localName = joinEntity.getKeyFieldNames()[0];
                            targetName = joinEntity.getKeyFieldNames()[1];
                        } else {
                            localName = joinEntity.getKeyFieldNames()[1];
                            targetName = joinEntity.getKeyFieldNames()[0];
                        }
                        Object localId = id;
                        ArrayList<HashMap> batchId = new ArrayList<HashMap>();
                        for (Object targetId : (Object[])entry.getValue()) {
                            batchId.add(New.hashMap((Object)localName, (Object)localId, (Object)targetName, (Object)targetId));
                        }
                        this.dao.createCriteriaQuery(joinEntity).where(joinIdFieldName1 + " = ?", new Object[]{id}).delete();
                        this.dao.batchInsert(joinEntity, batchId);
                    }
                }
            });
        }
        return result.get();
    }

    protected int executeUpdate(UpdateCommand update, Object id) {
        int r = (Integer)this.dao.withEvents(() -> update.execute());
        if (null != this.ex.handler) {
            this.ex.handler.postUpdateProperties(this.context, id, r);
        }
        return r;
    }
}

