/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import leap.core.value.Record;
import leap.core.value.SimpleRecord;
import leap.lang.Beans;
import leap.lang.Enumerable;
import leap.lang.Enumerables;
import leap.lang.Strings;
import leap.lang.collection.SimpleCaseInsensitiveMap;
import leap.lang.convert.Converts;
import leap.lang.jdbc.SimpleWhereBuilder;
import leap.lang.jdbc.WhereBuilder;
import leap.lang.logging.Log;
import leap.lang.logging.LogFactory;
import leap.lang.text.scel.ScelExpr;
import leap.lang.text.scel.ScelName;
import leap.lang.text.scel.ScelNode;
import leap.lang.text.scel.ScelToken;
import leap.orm.event.EntityListeners;
import leap.orm.mapping.EntityMapping;
import leap.orm.mapping.FieldMapping;
import leap.orm.mapping.RelationMapping;
import leap.orm.mapping.RelationProperty;
import leap.orm.query.CriteriaQuery;
import leap.orm.query.PageResult;
import leap.web.Params;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.meta.model.MApiProperty;
import leap.web.api.mvc.params.CountOptions;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.orm.DefaultModelExecutionContext;
import leap.web.api.orm.ExpandError;
import leap.web.api.orm.ExpandException;
import leap.web.api.orm.ModelExecutionContext;
import leap.web.api.orm.ModelExecutorBase;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelQueryExecutor;
import leap.web.api.orm.ModelQueryExtension;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.QueryOneResult;
import leap.web.api.query.Aggregate;
import leap.web.api.query.Expand;
import leap.web.api.query.ExpandParser;
import leap.web.api.query.GroupBy;
import leap.web.api.query.Join;
import leap.web.api.query.OrderBy;
import leap.web.api.query.Select;
import leap.web.api.query.SelectParser;
import leap.web.api.remote.RestQueryListResult;
import leap.web.api.remote.RestResource;
import leap.web.exception.BadRequestException;

public class DefaultModelQueryExecutor
extends ModelExecutorBase
implements ModelQueryExecutor {
    private static final Log log = LogFactory.get(DefaultModelQueryExecutor.class);
    protected final ModelAndMapping modelAndMapping = new ModelAndMapping(this.am, this.em);
    protected final ModelQueryExtension ex;
    protected ModelQueryExecutor.FindHandler findHandler;
    protected EntityListeners listeners;
    protected String sqlView;
    protected String[] excludedFields;
    protected boolean filterByParams = true;

    public DefaultModelQueryExecutor(ModelExecutorContext context) {
        this(context, null);
    }

    public DefaultModelQueryExecutor(ModelExecutorContext context, ModelQueryExtension ex) {
        super(context);
        this.ex = null == ex ? ModelQueryExtension.EMPTY : ex;
    }

    @Override
    public ModelQueryExecutor withFindHandler(ModelQueryExecutor.FindHandler handler) {
        this.findHandler = handler;
        return this;
    }

    @Override
    public ModelQueryExecutor withListeners(EntityListeners listeners) {
        this.listeners = listeners;
        return this;
    }

    @Override
    public ModelQueryExecutor fromSqlView(String sql) {
        this.sqlView = sql;
        return this;
    }

    @Override
    public ModelQueryExecutor selectExclude(String ... names) {
        this.excludedFields = names;
        return this;
    }

    @Override
    public ModelQueryExecutor setFilterByParams(boolean filterByParams) {
        this.filterByParams = filterByParams;
        return this;
    }

    @Override
    public QueryOneResult queryOne(Object id, QueryOptionsBase options) {
        if (this.remoteRest) {
            RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
            Record record = restResource.find(id, options);
            return new QueryOneResult(record);
        }
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        return (QueryOneResult)EntityMapping.withContextListeners((EntityListeners)this.listeners, () -> {
            this.ex.processQueryOneOptions(context, options);
            if (null != this.ex.handler) {
                this.ex.handler.processQueryOneOptions(context, id, options);
            }
            try {
                Record record;
                this.ex.preQueryOne(context);
                if (null != this.findHandler) {
                    record = this.queryOneByHandler(context, id, options);
                } else {
                    CriteriaQuery query = this.createCriteriaQuery().whereById(id);
                    this.applySelect(query, options, new JoinModels());
                    this.ex.preQueryOne(context, id, query);
                    if (null != this.ex.handler) {
                        this.ex.handler.preQueryOne(context, id, (CriteriaQuery<Record>)query);
                    }
                    record = (Record)this.dao.withEvents(() -> (Record)query.firstOrNull());
                }
                List<ExpandError> expandErrors = this.expandOne(context, record, options);
                if (null != this.ex.handler && null != record) {
                    this.ex.handler.postQueryOne(context, id, record);
                }
                Object entity = this.ex.processQueryOneRecord(context, id, record);
                QueryOneResult result = new QueryOneResult(record, entity, expandErrors);
                this.ex.completeQueryOne(context, result, null);
                return result;
            }
            catch (Throwable e) {
                this.ex.completeQueryOne(context, null, e);
                throw e;
            }
        });
    }

    protected Record queryOneByHandler(ModelExecutionContext context, Object id, QueryOptionsBase options) {
        Object result = this.findHandler.findOrNull(context, id, options);
        if (null == result) {
            return null;
        }
        if (result instanceof Record) {
            return (Record)result;
        }
        if (result instanceof Map) {
            return new SimpleRecord((Map)result);
        }
        Map map = Beans.toMap((Object)result);
        return new SimpleRecord(map);
    }

    protected List<ExpandError> expandOne(ModelExecutionContext context, Record record, QueryOptionsBase options) {
        Expand[] expands;
        if (null != record && null != options && (expands = options.getResolvedExpands()).length > 0) {
            ResolvedExpand[] resolvedExpands;
            ArrayList<ExpandError> expandErrors = new ArrayList<ExpandError>();
            List<Record> list = Arrays.asList(record);
            for (ResolvedExpand expand : resolvedExpands = this.resolveExpands(expands)) {
                try {
                    this.expand(context, expand, list);
                }
                catch (ExpandException e) {
                    expandErrors.add(new ExpandError(expand.name, e.getMessage(), e));
                }
            }
            return expandErrors;
        }
        return null;
    }

    @Override
    public QueryListResult queryList(QueryOptions options, Map<String, Object> filters, Consumer<CriteriaQuery> callback) {
        return this.queryList(options, filters, callback, this.filterByParams);
    }

    @Override
    public QueryListResult queryList(QueryOptions options, Map<String, Object> filters, Consumer<CriteriaQuery> callback, boolean filterByParams) {
        if (this.remoteRest) {
            RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
            RestQueryListResult<Object> result = filterByParams ? restResource.queryList(SimpleRecord.class, options, filters) : restResource.queryList(options);
            return new QueryListResult(result.getList(), result.getCount());
        }
        CriteriaQuery<Record> query = this.createCriteriaQuery();
        return this.doQueryListResult(query, new JoinModels(), options, filters, callback, filterByParams);
    }

    protected QueryListResult doQueryListResult(CriteriaQuery<Record> query, JoinModels joinModels, QueryOptions options, Map<String, Object> filters, Consumer<CriteriaQuery> callback) {
        return this.doQueryListResult(query, joinModels, options, filters, callback, this.filterByParams);
    }

    protected QueryListResult doQueryListResult(CriteriaQuery<Record> query, JoinModels joinModels, QueryOptions options, Map<String, Object> filters, Consumer<CriteriaQuery> callback, boolean filterByParams) {
        options.setAllowSingleExpr(true);
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        if (null == options) {
            options = new QueryOptions();
        }
        this.ex.processQueryListOptions(context, options);
        if (null != this.ex.handler) {
            this.ex.handler.processQueryListOptions(context, options);
        }
        if (!Strings.isEmpty((String)options.getSqlView())) {
            query.fromSqlView(options.getSqlView());
        }
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (null != this.context.getActionContext()) {
            allParams.putAll(this.context.getActionContext().getMergedParameters());
        }
        if (null != options.getQueryParams()) {
            allParams.putAll(options.getQueryParams());
        }
        query.params(allParams);
        Join[] joins = options.getResolvedJoins();
        if (null != joins && joins.length > 0) {
            HashSet<String> relations = new HashSet<String>();
            for (Join join : joins) {
                if (relations.contains(join.getRelation().toLowerCase())) {
                    throw new BadRequestException("Duplicated join relation '" + join.getRelation() + "'");
                }
                if (joinModels.contains(join.getAlias())) {
                    throw new BadRequestException("Duplicated join alias '" + join.getAlias() + "'");
                }
                if (join.getAlias().equalsIgnoreCase(query.alias())) {
                    throw new BadRequestException("Alias '" + query.alias() + "' is reserved, please use another one");
                }
                RelationProperty rp = this.em.tryGetRelationProperty(join.getRelation());
                if (null == rp) {
                    throw new BadRequestException("No relation '" + join.getRelation() + "' in model '" + this.am.getName() + " or the relation is not joinable");
                }
                if (rp.isOptional()) {
                    query.leftJoin(rp.getTargetEntityName(), rp.getRelationName(), join.getAlias());
                } else {
                    query.join(rp.getTargetEntityName(), rp.getRelationName(), join.getAlias());
                }
                relations.add(join.getRelation().toLowerCase());
                ModelAndMapping joinModel = this.lookupModelAndMapping(rp.getTargetEntityName());
                if (null == joinModel) {
                    throw new BadRequestException("The joined model '" + rp.getTargetEntityName() + "' of relation '" + join.getRelation() + "' not found");
                }
                joinModels.add(join.getAlias(), joinModel);
            }
        }
        this.applyOrderBy(query, options, joinModels);
        this.applySelectOrAggregates(query, options, joinModels);
        this.applyFilters(context, query, options.getParams(), options, joinModels, filters, filterByParams);
        if (callback != null) {
            callback.accept(query);
        }
        QueryOptions finalOptions = options;
        return (QueryListResult)EntityMapping.withContextListeners((EntityListeners)this.listeners, () -> {
            long count = -1L;
            try {
                Expand[] expands;
                this.ex.preQueryList(context, query);
                if (null != this.ex.handler) {
                    this.ex.handler.preQueryList(context, query);
                }
                PageResult page = query.pageResult(finalOptions.getPage(this.ac.getDefaultPageSize()));
                List list = this.ex.executeQueryList(context, finalOptions, query);
                if (null == list) {
                    list = (List)this.dao.withEvents(() -> page.list());
                }
                if (null != this.ex.handler) {
                    this.ex.handler.postQueryList(context, list);
                }
                ArrayList<ExpandError> expandErrors = new ArrayList<ExpandError>();
                if (!list.isEmpty() && (expands = ExpandParser.parse(finalOptions.getExpand())).length > 0) {
                    ResolvedExpand[] resolvedExpands = this.resolveExpands(expands);
                    int maxPageSize = this.ac.getMaxPageSizeWithExpandOne();
                    for (ResolvedExpand expand : resolvedExpands) {
                        if (expand.isEmbedded() || !expand.rm.isOneToMany() && !expand.rm.isOneToMany()) continue;
                        maxPageSize = this.ac.getMaxPageSizeWithExpandMany();
                        break;
                    }
                    if (list.size() > maxPageSize) {
                        throw new BadRequestException("The result size " + list.size() + " exceed max expand " + maxPageSize + ", please decrease your page_size");
                    }
                    for (ResolvedExpand expand : resolvedExpands) {
                        try {
                            this.expand(context, expand, list);
                        }
                        catch (ExpandException e) {
                            expandErrors.add(new ExpandError(expand.getName(), e.getMessage(), e.getCause()));
                        }
                    }
                }
                if (finalOptions.isTotal()) {
                    count = query.count();
                }
                Object entity = this.ex.processQueryListResult(context, page, count, list);
                QueryListResult result = new QueryListResult(list, count, entity, expandErrors);
                this.ex.completeQueryList(context, result, null);
                return result;
            }
            catch (Throwable e) {
                this.ex.completeQueryList(context, null, e);
                throw e;
            }
        });
    }

    @Override
    public QueryListResult count(CountOptions options, Consumer<CriteriaQuery> callback) {
        if (this.remoteRest) {
            RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
            return new QueryListResult(null, restResource.count(options), null);
        }
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        CriteriaQuery<Record> query = this.createCriteriaQuery();
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setFilters(options.getFilters());
        this.applyFilters(context, query, null, queryOptions, null, null);
        this.applyCount(context, query);
        if (callback != null) {
            callback.accept(query);
        }
        long count = query.count();
        return new QueryListResult(null, count, null);
    }

    protected CriteriaQuery<Record> createCriteriaQuery() {
        return this.dao.createCriteriaQuery(this.em).fromSqlView(this.sqlView);
    }

    protected void expand(ModelExecutionContext context, ResolvedExpand expand, List<Record> records) {
        if (records == null || records.size() == 0) {
            return;
        }
        if (expand.isRemoteRest()) {
            this.expandByRest(context, expand, records);
        } else {
            this.expandByDb(context, expand, records);
        }
    }

    protected void expandByRest(ModelExecutionContext context, ResolvedExpand expand, List<Record> records) {
        RestQueryListResult<Map> resultList;
        String referredFieldName;
        String localFieldName;
        RelationMapping rm;
        if (expand.isEmbedded()) {
            this.expandByRestEmbedded(expand, records);
            return;
        }
        QueryOptions opts = new QueryOptions();
        opts.setLimit(this.ac.getMaxRecordsPerExpand() + 1);
        RestResource resource = this.restResourceFactory.createResource(this.dao.getOrmContext(), expand.tem);
        if (expand.tem.getRemoteSettings().isExpandCanNewAccessToken()) {
            resource.setCanNewAccessToken(true);
        }
        if ((rm = expand.rm).isOneToMany()) {
            RelationMapping inverseRm = this.md.getEntityMapping(rm.getJoinEntityName()).getRelationMapping(rm.getInverseRelationName());
            localFieldName = inverseRm.getJoinFields()[0].getReferencedFieldName();
            referredFieldName = inverseRm.getJoinFields()[0].getLocalFieldName();
        } else {
            if (rm.isManyToMany()) {
                throw new BadRequestException("Unsupported remote entity expand when relation type is many-to-many");
            }
            localFieldName = rm.getJoinFields()[0].getLocalFieldName();
            referredFieldName = rm.getJoinFields()[0].getReferencedFieldName();
        }
        HashSet fks = new HashSet();
        for (Record record : records) {
            Iterator fk = record.get((Object)localFieldName);
            if (fk == null || fks.contains(fk)) continue;
            fks.add(fk);
        }
        StringBuilder filters = new StringBuilder();
        int i = 0;
        for (Object e : fks) {
            if (i > 0) {
                filters.append(',');
            }
            filters.append(e.toString());
            ++i;
        }
        opts.setFilters(Strings.format((String)"{0} in ({1})", (Object[])new Object[]{referredFieldName, filters.toString()}));
        if (Strings.isNotEmpty((String)expand.getSelect())) {
            if (expand.getSelect().contains(referredFieldName)) {
                opts.setSelect(expand.getSelect());
            } else {
                opts.setSelect(expand.getSelect() + "," + referredFieldName);
            }
        }
        try {
            resultList = resource.queryList(Map.class, opts);
        }
        catch (Exception exception) {
            log.error("Expand by rest error, {}", new Object[]{exception.getMessage(), exception});
            throw new ExpandException(exception);
        }
        if (resultList.getCount() > (long)this.ac.getMaxRecordsPerExpand()) {
            throw new BadRequestException("Expanded records of '" + expand.getName() + "' exceed max limit " + this.ac.getMaxRecordsPerExpand());
        }
        HashMap hashMap = new HashMap();
        for (Map referred : resultList.getList()) {
            Object fkVal = null;
            List<SimpleRecord> fieldToValList = null;
            if (rm.isManyToMany()) {
                fkVal = referred.remove(referredFieldName);
                if (fkVal == null) {
                    fkVal = referred.remove(referredFieldName.toUpperCase());
                }
                if (fkVal == null) {
                    fkVal = referred.remove(referredFieldName.toLowerCase());
                }
            } else {
                fkVal = referred.get(referredFieldName);
            }
            if (hashMap.containsKey(fkVal)) {
                fieldToValList = (List)hashMap.get(fkVal);
            } else {
                fieldToValList = new ArrayList();
                hashMap.put(fkVal, fieldToValList);
            }
            fieldToValList.add(new SimpleRecord(referred));
        }
        RelationProperty rp = expand.rp;
        for (Record record : records) {
            Object fk = record.get((Object)localFieldName);
            List fieldToRecords = (List)hashMap.get(fk);
            if (rp.isMany()) {
                record.put((Object)rp.getName(), (Object)(null == fieldToRecords ? Collections.emptyList() : fieldToRecords));
                continue;
            }
            if (fieldToRecords != null && fieldToRecords.size() > 0) {
                record.put((Object)rp.getName(), fieldToRecords.get(0));
                continue;
            }
            record.put((Object)rp.getName(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandByDb(ModelExecutionContext context, ResolvedExpand expand, List<Record> records) {
        if (expand.isEmbedded()) {
            this.expandByDbEmbedded(expand, records);
            return;
        }
        this.ex.preExpand(context);
        try {
            String referredFieldName;
            String localFieldName;
            RelationProperty rp = expand.rp;
            RelationMapping rm = expand.rm;
            CriteriaQuery expandQuery = this.dao.createCriteriaQuery(rp.getTargetEntityName()).limit(Integer.valueOf(this.ac.getMaxRecordsPerExpand() + 1));
            if (rm.isOneToMany()) {
                RelationMapping inverseRm = this.md.getEntityMapping(rm.getTargetEntityName()).getRelationMapping(rm.getInverseRelationName());
                localFieldName = inverseRm.getJoinFields()[0].getReferencedFieldName();
                referredFieldName = inverseRm.getJoinFields()[0].getLocalFieldName();
            } else if (rm.isManyToMany()) {
                RelationMapping joinRm = this.md.getEntityMapping(rm.getJoinEntityName()).tryGetRelationMappingOfTargetEntity(this.em.getEntityName());
                localFieldName = this.em.getKeyFieldNames()[0];
                referredFieldName = joinRm.getJoinFields()[0].getLocalFieldName();
                expandQuery.join(rm.getJoinEntityName(), "_jt_");
            } else {
                localFieldName = rm.getJoinFields()[0].getLocalFieldName();
                referredFieldName = rm.getJoinFields()[0].getReferencedFieldName();
            }
            String referredFieldAlias = rm.getTargetEntityName() + "_" + referredFieldName;
            HashSet<Object> fks = new HashSet<Object>();
            for (Record record : records) {
                Object fk = record.get((Object)localFieldName);
                if (fk == null || fks.contains(fk)) continue;
                fks.add(fk);
            }
            if (rm.isManyToMany()) {
                expandQuery.where(Strings.format((String)"_jt_.{0} in :fks", (Object[])new Object[]{referredFieldName})).param("fks", (Object)fks.toArray());
            } else {
                expandQuery.where(Strings.format((String)"{0} in :fks", (Object[])new Object[]{referredFieldName})).param("fks", (Object)fks.toArray());
            }
            if (Strings.isEmpty((String)expand.getSelect())) {
                if (rm.isManyToMany()) {
                    expandQuery.select(new String[]{"*", Strings.format((String)"_jt_.{0} as {1}", (Object[])new Object[]{referredFieldName, referredFieldAlias})});
                } else {
                    referredFieldAlias = referredFieldName;
                }
            } else if (rm.isManyToMany()) {
                this.applySelect(expandQuery, expand.getSelect(), Strings.format((String)"_jt_.{0} as {1}", (Object[])new Object[]{referredFieldName, referredFieldAlias}));
            } else {
                this.applySelect(expandQuery, expand.getSelect(), referredFieldName);
                referredFieldAlias = referredFieldName;
            }
            this.ex.preExpand(context, (CriteriaQuery<Record>)expandQuery);
            List resultList = expandQuery.list();
            if (resultList.size() > this.ac.getMaxRecordsPerExpand()) {
                throw new BadRequestException("Expanded records of '" + rp.getName() + "' exceed max limit " + this.ac.getMaxRecordsPerExpand());
            }
            HashMap referredRecords = new HashMap();
            for (Record referred : resultList) {
                List<Record> fieldToValList;
                Object fkVal;
                if (rm.isManyToMany()) {
                    fkVal = referred.remove((Object)referredFieldAlias);
                    if (fkVal == null) {
                        fkVal = referred.remove((Object)referredFieldAlias.toUpperCase());
                    }
                    if (fkVal == null) {
                        fkVal = referred.remove((Object)referredFieldAlias.toLowerCase());
                    }
                } else {
                    fkVal = referred.get((Object)referredFieldAlias);
                }
                if (referredRecords.containsKey(fkVal)) {
                    fieldToValList = (List)referredRecords.get(fkVal);
                } else {
                    fieldToValList = new ArrayList();
                    referredRecords.put(fkVal, fieldToValList);
                }
                fieldToValList.add(referred);
            }
            for (Record record : records) {
                Object fk = record.get((Object)localFieldName);
                List fieldToRecords = (List)referredRecords.get(fk);
                if (rp.isMany()) {
                    record.put((Object)rp.getName(), (Object)(null == fieldToRecords ? Collections.emptyList() : fieldToRecords));
                    continue;
                }
                if (fieldToRecords != null && fieldToRecords.size() > 0) {
                    record.put((Object)rp.getName(), fieldToRecords.get(0));
                    continue;
                }
                record.put((Object)rp.getName(), null);
            }
        }
        finally {
            this.ex.completeExpand(context);
        }
    }

    protected void expandByRestEmbedded(ResolvedExpand expand, List<Record> records) {
        RelationMapping rm = expand.rm;
        RelationProperty rp = expand.rp;
        HashSet<Object> ids = new HashSet<Object>();
        records.forEach(r -> this.calcIdsByEmbeddedField((Set<Object>)ids, (Record)r, rm.getEmbeddedFileName()));
        if (ids.isEmpty()) {
            return;
        }
        EntityMapping targetEm = this.md.getEntityMapping(rm.getTargetEntityName());
        String idFieldName = targetEm.getKeyFieldNames()[0];
        RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), targetEm);
        if (targetEm.getRemoteSettings().isExpandCanNewAccessToken()) {
            restResource.setCanNewAccessToken(true);
        }
        ArrayList<Map> totalExpanded = new ArrayList<Map>();
        for (List<Object> partOfIds : this.split(ids, 50)) {
            RestQueryListResult<Map> listResult;
            String filter = idFieldName + " in (" + this.joinInIds(partOfIds) + ")";
            QueryOptions options = new QueryOptions();
            options.setFilters(filter);
            try {
                listResult = restResource.queryList(Map.class, options);
            }
            catch (Exception e) {
                log.error("Expand by reset error, {}", new Object[]{e.getMessage(), e});
                throw new ExpandException(e);
            }
            totalExpanded.addAll(listResult.getList());
        }
        Map<Object, Map> totalExpandedMap = totalExpanded.stream().collect(Collectors.toMap(r -> r.get(idFieldName), r -> r));
        for (Record record : records) {
            Object embeddedIds = record.get((Object)rm.getEmbeddedFileName());
            ArrayList<Map> expandedList = new ArrayList<Map>();
            if (null != embeddedIds) {
                for (Object embeddedId : Enumerables.of((Object)embeddedIds)) {
                    Map expandedRecord = totalExpandedMap.get(embeddedId);
                    if (null == expandedRecord) continue;
                    expandedList.add(expandedRecord);
                }
            }
            record.put((Object)rp.getName(), expandedList);
        }
    }

    protected String joinInIds(List<Object> ids) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append("'");
            s.append(ids.get(i));
            s.append("'");
        }
        return s.toString();
    }

    protected List<List<Object>> split(Set<Object> set, int num) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        int j = 0;
        ArrayList<Object> itemList = new ArrayList<Object>();
        list.add(itemList);
        for (Object item : set) {
            if (j == num) {
                j = 0;
                itemList = new ArrayList();
                list.add(itemList);
            } else {
                ++j;
            }
            itemList.add(item);
        }
        return list;
    }

    protected void expandByDbEmbedded(ResolvedExpand expand, List<Record> records) {
        List totalExpanded;
        RelationMapping rm = expand.rm;
        HashSet ids = new HashSet();
        records.forEach(r -> this.calcIdsByEmbeddedField(ids, (Record)r, rm.getEmbeddedFileName()));
        if (ids.isEmpty()) {
            return;
        }
        EntityMapping targetEm = this.md.getEntityMapping(rm.getTargetEntityName());
        String idFieldName = targetEm.getKeyFieldNames()[0];
        CriteriaQuery expandQuery = this.dao.createCriteriaQuery(targetEm).where(idFieldName + " in ?", new Object[]{ids});
        if (!Strings.isEmpty((String)expand.getSelect())) {
            this.applySelect(expandQuery, expand.getSelect(), false, idFieldName);
        }
        if ((totalExpanded = expandQuery.limit(Integer.valueOf(this.ac.getMaxRecordsPerExpand() + 1)).list()).size() > this.ac.getMaxRecordsPerExpand()) {
            throw new BadRequestException("Expanded records of '" + expand.getName() + "' exceed max limit " + this.ac.getMaxRecordsPerExpand());
        }
        Map<Object, Record> totalExpandedMap = totalExpanded.stream().collect(Collectors.toMap(r -> r.get((Object)idFieldName), r -> r));
        for (Record record : records) {
            Object embeddedIds = record.get((Object)rm.getEmbeddedFileName());
            ArrayList<Record> expandedList = new ArrayList<Record>();
            if (null != embeddedIds) {
                for (Object embeddedId : Enumerables.of((Object)embeddedIds)) {
                    Record expandedRecord = totalExpandedMap.get(embeddedId);
                    if (null == expandedRecord) continue;
                    expandedList.add(expandedRecord);
                }
            }
            record.put((Object)expand.rp.getName(), expandedList);
        }
    }

    public void calcIdsByEmbeddedField(Set<Object> ids, Record record, String embeddedFieldName) {
        Object embeddedIds = record.get((Object)embeddedFieldName);
        if (null != embeddedIds) {
            Enumerable enumerable = Enumerables.tryOf((Object)embeddedIds);
            if (null == enumerable) {
                throw new BadRequestException("The embedded ids must be array at field '" + embeddedFieldName + "'");
            }
            for (Object item : enumerable) {
                if (ids.contains(item)) continue;
                ids.add(item);
            }
        }
    }

    @Deprecated
    protected void expand(Record record, Object id, Expand expand) {
        String name = expand.getName();
        MApiProperty ap = this.am.tryGetProperty(name);
        if (null == ap) {
            throw new BadRequestException("The expand property '" + name + "' not exists!");
        }
        RelationProperty rp = this.em.tryGetRelationProperty(name);
        if (null == rp) {
            throw new BadRequestException("Property '" + name + "' cannot be expanded");
        }
        RelationMapping rm = this.em.getRelationMapping(rp.getRelationName());
        CriteriaQuery expandQuery = this.dao.createCriteriaQuery(rp.getTargetEntityName()).joinById(this.em.getEntityName(), rm.getInverseRelationName(), "t_" + this.em.getEntityName(), id);
        if (!Strings.isEmpty((String)expand.getSelect())) {
            this.applySelect(expandQuery, expand.getSelect());
        }
        if (rp.isMany()) {
            record.put((Object)rp.getName(), (Object)expandQuery.list());
        } else {
            record.put((Object)rp.getName(), expandQuery.firstOrNull());
        }
    }

    protected void applyOrderBy(CriteriaQuery query, QueryOptions options, JoinModels joinModels) {
        OrderBy orderBy = options.getResolvedOrderBy();
        if (null == orderBy) {
            return;
        }
        OrderBy.Item[] items = orderBy.items();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            OrderBy.Item item = items[i];
            String expr = (String)this.em.getOrderByExprs().get(item.name());
            if (null != expr) {
                s.append(expr);
            } else {
                MApiModel model;
                if (item.hasAlias() && !item.alias().equalsIgnoreCase(query.alias())) {
                    ModelAndMapping jm = joinModels.get(item.alias());
                    if (null == jm) {
                        throw new BadRequestException("Can't found join alias '" + item.alias() + "', check order by");
                    }
                    model = jm.model;
                } else {
                    model = this.am;
                }
                String name = item.name();
                MApiProperty ap = model.tryGetProperty(name);
                boolean isAlias = false;
                if (null == ap) {
                    if (null != options.getResolvedSelect() && options.getResolvedSelect().aliasContain(name)) {
                        isAlias = true;
                    } else if (null != options.getResolvedGroupBy() && options.getResolvedGroupBy().aliasContain(name)) {
                        isAlias = true;
                    } else if (null != options.getResolvedAggregate() && options.getResolvedAggregate().aliasContain(name)) {
                        isAlias = true;
                    }
                    if (!isAlias) {
                        throw new BadRequestException("Property '" + name + "' not exists in model '" + model.getName() + "'");
                    }
                } else if (ap.isNotSortableExplicitly()) {
                    throw new BadRequestException("Property '" + name + "' is not sortable in model '" + model.getName() + "'");
                }
                if (isAlias) {
                    s.append(item.name());
                } else if (item.hasAlias()) {
                    s.append(item.alias()).append('.').append(item.name());
                } else if (Strings.isNotEmpty((String)query.alias())) {
                    s.append(query.alias()).append('.').append(item.name());
                } else {
                    s.append(item.name());
                }
            }
            if (item.isAscending()) continue;
            s.append(" desc");
        }
        query.orderBy(s.toString());
    }

    protected void applySelect(CriteriaQuery query, String select) {
        if (Strings.equals((String)"*", (String)select)) {
            return;
        }
        EntityMapping em = query.getEntityMapping();
        String[] names = Strings.split((String)select, (char)',');
        ArrayList<String> fields = new ArrayList<String>();
        for (String name : names) {
            FieldMapping p = em.tryGetFieldMapping(name);
            if (null == p) {
                throw new BadRequestException("Property '" + name + "' not exists, check the 'select' query param");
            }
            fields.add(p.getFieldName());
        }
        if (null != this.excludedFields) {
            for (String name : this.excludedFields) {
                fields.remove(name);
            }
        }
        query.select(fields.toArray(new String[fields.size()]));
    }

    protected void applySelect(CriteriaQuery query, String select, String ... requiredFields) {
        this.applySelect(query, select, true, requiredFields);
    }

    protected void applySelect(CriteriaQuery query, String select, boolean exclude, String ... requiredFields) {
        if (Strings.equals((String)"*", (String)select)) {
            return;
        }
        EntityMapping em = query.getEntityMapping();
        String[] names = Strings.split((String)select, (char)',');
        ArrayList<String> fields = new ArrayList<String>();
        for (String name : names) {
            FieldMapping p = em.tryGetFieldMapping(name);
            if (null == p) {
                throw new BadRequestException("Property '" + name + "' not exists, check the 'select' query param");
            }
            fields.add(p.getFieldName());
        }
        if (exclude && null != this.excludedFields) {
            for (String name : this.excludedFields) {
                fields.remove(name);
            }
        }
        if (requiredFields != null && requiredFields.length > 0) {
            for (String requiredField : requiredFields) {
                boolean isContain = false;
                for (String field : fields) {
                    if (!Strings.equalsIgnoreCase((String)requiredField, (String)field)) continue;
                    isContain = true;
                    break;
                }
                if (isContain) continue;
                fields.add(requiredField);
            }
        }
        query.select(fields.toArray(new String[fields.size()]));
    }

    protected void applySelect(CriteriaQuery query, QueryOptionsBase options, JoinModels joins) {
        ArrayList<String> fields = new ArrayList<String>();
        this.applySelectItems(options, joins, fields);
        query.select(fields.toArray(new String[fields.size()]));
    }

    protected void applySelectItems(QueryOptionsBase options, JoinModels joins, List<String> items) {
        String select;
        String string = select = null == options ? null : options.getSelect();
        if (Strings.isEmpty((String)select) || "*".equals(select)) {
            for (MApiProperty p : this.am.getProperties()) {
                if (p.isReference() || !p.isSelectableExplicitly()) continue;
                items.add(p.getName());
            }
        } else {
            Select.Item[] selectItems = options instanceof QueryOptions ? ((QueryOptions)options).getResolvedSelect().items() : SelectParser.parse(options.getSelect()).items();
            Select.Item[] itemArray = selectItems;
            int n = itemArray.length;
            for (int p = 0; p < n; ++p) {
                Select.Item selectItem = itemArray[p];
                if (Strings.isEmpty((String)selectItem.joinAlias())) {
                    if (selectItem.name().equals("*")) {
                        for (MApiProperty p2 : this.am.getProperties()) {
                            if (p2.isReference() || !p2.isSelectableExplicitly()) continue;
                            items.add(p2.getName());
                        }
                        continue;
                    }
                    String expr = (String)this.em.getSelectExprs().get(selectItem.name());
                    if (null != expr) {
                        if (Strings.isEmpty((String)selectItem.alias())) {
                            items.add("(" + expr + ") as " + selectItem.name());
                            continue;
                        }
                        items.add("(" + expr + ") as " + selectItem.alias());
                        continue;
                    }
                    MApiProperty p3 = this.am.tryGetProperty(selectItem.name());
                    if (null == p3) {
                        throw new BadRequestException("Property '" + selectItem.name() + "' not exists, check the 'select' query param");
                    }
                    if (!p3.isSelectableExplicitly()) {
                        throw new BadRequestException("Property '" + selectItem.name() + "' is not selectable");
                    }
                    if (Strings.isEmpty((String)selectItem.alias())) {
                        items.add(p3.getName());
                        continue;
                    }
                    items.add(p3.getName() + " as " + selectItem.alias());
                    continue;
                }
                if (!Strings.isNotEmpty((String)selectItem.joinAlias())) continue;
                ModelAndMapping join = joins.get(selectItem.joinAlias());
                if (null == join) {
                    throw new BadRequestException("The join alias '" + selectItem.joinAlias() + "' not exists, check '" + selectItem.joinAlias() + "." + selectItem.name() + "'");
                }
                MApiProperty p4 = join.model.tryGetProperty(selectItem.name());
                if (null == p4) {
                    throw new BadRequestException("Join property '" + selectItem.joinAlias() + "." + selectItem.name() + "' not exists, check the 'select' query param");
                }
                if (!p4.isSelectableExplicitly()) {
                    throw new BadRequestException("Join Property '" + selectItem.joinAlias() + "." + selectItem.name() + "' is not selectable");
                }
                FieldMapping fm = join.mapping.getFieldMapping(p4.getName());
                if (Strings.isEmpty((String)selectItem.alias())) {
                    items.add(selectItem.joinAlias() + "." + fm.getColumnName());
                    continue;
                }
                items.add(selectItem.joinAlias() + "." + fm.getColumnName() + " " + selectItem.alias());
            }
        }
        if (null != this.excludedFields && this.excludedFields.length > 0) {
            for (String name : this.excludedFields) {
                items.remove(name);
            }
        }
    }

    protected void applySelectOrAggregates(CriteriaQuery query, QueryOptions options, JoinModels joins) {
        String expr;
        if (Strings.isEmpty((String)options.getAggregates()) && Strings.isEmpty((String)options.getGroupBy())) {
            this.applySelect(query, options, joins);
            return;
        }
        if (!Strings.isEmpty((String)options.getSelect())) {
            throw new BadRequestException("Can't use 'select' for aggregation or groupby query");
        }
        ArrayList<String> select = new ArrayList<String>();
        if (!Strings.isEmpty((String)options.getGroupBy())) {
            if (Strings.isEmpty((String)options.getAggregates())) {
                throw new BadRequestException("Must use groupby with aggregates");
            }
            GroupBy.Item[] items = options.getResolvedGroupBy().items();
            StringBuilder groupBy = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                MApiModel m;
                if (i > 0) {
                    groupBy.append(',');
                }
                GroupBy.Item item = items[i];
                expr = (String)this.em.getGroupByExprs().get(item.name());
                if (null != expr) {
                    if (Strings.isEmpty((String)item.alias())) {
                        select.add("(" + expr + ") as " + item.name());
                    } else {
                        select.add("(" + expr + ") as " + item.alias());
                    }
                    groupBy.append("(" + expr + ")");
                    continue;
                }
                if (Strings.isNotEmpty((String)item.joinAlias())) {
                    ModelAndMapping join = joins.get(item.joinAlias());
                    if (null == join) {
                        throw new BadRequestException("Can't found join alias '" + item.joinAlias() + "', check group by");
                    }
                    m = join.model;
                } else {
                    m = this.am;
                }
                MApiProperty p = m.tryGetProperty(item.name());
                if (null == p) {
                    throw new BadRequestException("Property '" + m.getName() + "." + item.name() + "' not exists, check the 'groupby'");
                }
                if (!p.isSelectableExplicitly()) {
                    throw new BadRequestException("Property '" + m.getName() + "." + item.name() + "' is not groupable");
                }
                StringBuffer sql = new StringBuffer();
                if (null != item.joinAlias()) {
                    sql.append(item.joinAlias() + "." + p.getName());
                } else {
                    sql.append(p.getName());
                }
                if (null != item.alias()) {
                    sql.append(" as " + item.alias());
                    groupBy.append(item.alias());
                } else {
                    groupBy.append(sql);
                }
                select.add(sql.toString());
            }
            query.groupBy(groupBy.toString());
        }
        for (Aggregate.Item item : options.getResolvedAggregate().items()) {
            expr = (String)this.em.getAggregatesExprs().get(item.name());
            if (Strings.isEmpty((String)expr)) {
                if (Strings.isEmpty((String)item.function())) {
                    throw new BadRequestException("Not find aggregation function in '" + item.name() + "'");
                }
                if (item.name().equals("*")) {
                    select.add(item.function() + "(" + item.name() + ") as " + item.alias());
                    continue;
                }
                MApiProperty p = this.am.tryGetProperty(item.name());
                if (null == p) {
                    throw new BadRequestException("Property '" + item.name() + "' not exists, check the 'aggregates' param");
                }
                if (!p.isAggregatableExplicitly()) {
                    throw new BadRequestException("Property '" + item.name() + "' is not aggregatable");
                }
                select.add(item.function() + "(" + query.alias() + "." + item.name() + ") as " + item.alias());
                continue;
            }
            select.add(expr + " as " + item.name());
        }
        query.select(select.toArray(new String[select.size()]));
    }

    protected void applyCount(ModelExecutionContext context, CriteriaQuery query) {
        if (null != this.ex.handler) {
            this.ex.handler.preCount(context, (CriteriaQuery<Record>)query);
        }
        this.ex.preCount(context, query);
    }

    protected void applyFilters(ModelExecutionContext context, CriteriaQuery query, Params params, QueryOptions options, JoinModels jms, Map<String, Object> fields) {
        this.applyFilters(context, query, params, options, jms, fields, this.filterByParams);
    }

    protected void applyFilters(ModelExecutionContext context, CriteriaQuery query, Params params, QueryOptions options, JoinModels jms, Map<String, Object> fields, boolean filterByParams) {
        ScelNode[] nodes;
        ScelExpr filters;
        SimpleWhereBuilder where = new SimpleWhereBuilder();
        if (null != this.ex.handler) {
            this.ex.handler.preProcessQueryListWhere(context, options, (WhereBuilder)where);
        }
        this.ex.preProcessQueryListWhere(context, options, (WhereBuilder)where);
        if (!Strings.isEmpty((String)options.getViewId()) && null == this.ex.handler) {
            throw new BadRequestException("'viewId' not supported");
        }
        if (null != this.ex.handler) {
            this.ex.handler.handleQueryListView(context, options.getViewId(), (WhereBuilder)where);
        }
        if (null != fields && !fields.isEmpty()) {
            where.and(expr -> {
                int i = 0;
                for (Map.Entry entry : fields.entrySet()) {
                    if (i > 0) {
                        expr.append(" and ");
                    }
                    ++i;
                    if (null != entry.getValue() && entry.getValue().getClass().isArray()) {
                        expr.append(query.alias()).append('.').append((String)entry.getKey()).append(" in ?");
                    } else {
                        expr.append(query.alias()).append('.').append((String)entry.getKey()).append(" = ?");
                    }
                    expr.arg(entry.getValue());
                }
            });
        }
        if (null != params && filterByParams) {
            where.and(expr -> {
                for (String name : params.names()) {
                    String alias;
                    int dotIndex = name.indexOf(46);
                    if (dotIndex > 0) {
                        alias = name.substring(0, dotIndex);
                        name = name.substring(dotIndex + 1);
                        if (null == jms || !jms.contains(alias.toLowerCase())) {
                            throw new BadRequestException("Unknown alias '" + alias + "' at param '" + alias + "." + name + "'");
                        }
                    } else {
                        alias = query.alias();
                    }
                    ModelAndProp modelAndProp = this.lookupModelAndProp(jms, alias, name);
                    if (null == modelAndProp.property) continue;
                    this.checkProperty(modelAndProp, name);
                    String value = params.get(name);
                    if (Strings.isEmpty((String)value)) continue;
                    String[] a = params.getArray(name);
                    if (a.length == 1) {
                        a = Strings.split((String)a[0], (char)',');
                    }
                    if (a.length > 1) {
                        this.applyFieldFilterIn((WhereBuilder.Expr)expr, alias, modelAndProp.field, a);
                        continue;
                    }
                    this.applyFieldFilter((WhereBuilder.Expr)expr, alias, modelAndProp.field, value, "=");
                }
            });
        }
        if (null != (filters = options.getResolvedFilters()) && (nodes = filters.nodes()).length > 0) {
            where.and(expr -> {
                for (int i = 0; i < nodes.length; ++i) {
                    ScelNode node = nodes[i];
                    if (node.isParen()) {
                        expr.append(node.literal());
                        continue;
                    }
                    if (node.isAnd()) {
                        expr.append(" and ");
                        continue;
                    }
                    if (node.isOr()) {
                        expr.append(" or ");
                        continue;
                    }
                    ScelName nameNode = (ScelName)nodes[i];
                    String name = nameNode.literal();
                    String filtersExpr = (String)this.em.getFiltersExprs().get(name);
                    if (!Strings.isEmpty((String)filtersExpr)) {
                        expr.append(filtersExpr);
                        continue;
                    }
                    String alias = nameNode.alias();
                    ScelToken op = nodes[++i].token();
                    String value = nodes[++i].literal();
                    if (null == op && Strings.isEmpty((String)value)) {
                        throw new BadRequestException("Invalid filter expr in '" + name + "'");
                    }
                    if (null != alias) {
                        if (null == jms || !jms.contains(alias)) {
                            throw new BadRequestException("Unknown alias '" + alias + "' at property '" + nameNode.toString() + "'");
                        }
                    } else {
                        alias = query.alias();
                    }
                    ModelAndProp modelAndProp = this.lookupModelAndProp(jms, alias, name);
                    this.checkProperty(modelAndProp, name);
                    String sqlOperator = this.toSqlOperator(op);
                    if (op == ScelToken.IS || op == ScelToken.IS_NOT) {
                        expr.append(alias).append('.').append(name).append(' ').append(sqlOperator);
                        continue;
                    }
                    if (op == ScelToken.SW) {
                        value = "%" + value;
                    } else if (op == ScelToken.EW) {
                        value = value + "%";
                    } else if (op == ScelToken.CO) {
                        value = "%" + value + "%";
                    }
                    if (op == ScelToken.IN || op == ScelToken.NOT_IN) {
                        this.applyFieldFilterIn((WhereBuilder.Expr)expr, alias, modelAndProp.field, nodes[i].values(), sqlOperator);
                        continue;
                    }
                    if (value.endsWith("()") && value.length() > 2) {
                        String envName = value.substring(0, value.length() - 2);
                        String valueExpr = "#{env." + envName + "}";
                        this.applyFieldFilterExpr((WhereBuilder.Expr)expr, alias, modelAndProp.field, valueExpr, sqlOperator);
                        continue;
                    }
                    if (value.startsWith("env.")) {
                        String valueExpr = "#{" + value + "}";
                        this.applyFieldFilterExpr((WhereBuilder.Expr)expr, alias, modelAndProp.field, valueExpr, sqlOperator);
                        continue;
                    }
                    this.applyFieldFilter((WhereBuilder.Expr)expr, alias, modelAndProp.field, value, sqlOperator);
                }
            });
        }
        if (null != this.ex.handler) {
            this.ex.handler.postProcessQueryListWhere(context, options, (WhereBuilder)where);
        }
        this.ex.postProcessQueryListWhere(context, options, (WhereBuilder)where);
        if (!where.isEmpty()) {
            query.where(where.getWhere().toString(), where.getArgs().toArray());
        }
    }

    protected void checkProperty(ModelAndProp modelAndProp, String name) {
        boolean joined = modelAndProp.model != this.am;
        String modelDesc = (joined ? "joined " : "") + "model '" + modelAndProp.model.getName() + "'";
        if (null == modelAndProp.property) {
            throw new BadRequestException("Property '" + name + "' not exists in " + modelDesc);
        }
        if (null == modelAndProp.field) {
            throw new BadRequestException("No mapping field '" + name + "' in " + modelDesc);
        }
        MApiProperty ap = modelAndProp.property;
        if (ap.isNotFilterableExplicitly()) {
            throw new BadRequestException("Property '" + name + "' is not filterable in " + modelDesc);
        }
        if (ap.isReference()) {
            throw new BadRequestException("Relation Property '" + name + "' is not filterable in " + modelDesc);
        }
    }

    protected ModelAndMapping lookupModelAndMapping(String entityName) {
        MApiModel model = this.amd.getModel(entityName);
        if (null == model) {
            return null;
        }
        EntityMapping mapping = this.md.getEntityMapping(entityName);
        if (null == mapping) {
            throw new IllegalStateException("Entity mapping '" + entityName + "' should be exists!");
        }
        return new ModelAndMapping(model, mapping);
    }

    protected ModelAndProp lookupModelAndProp(JoinModels joinedModels, String alias, String propertyName) {
        MApiProperty property;
        ModelAndMapping modelAndMapping = null;
        if (null != joinedModels) {
            modelAndMapping = joinedModels.get(alias.toLowerCase());
        }
        if (null == modelAndMapping) {
            modelAndMapping = this.modelAndMapping;
        }
        FieldMapping field = null == (property = modelAndMapping.model.tryGetProperty(propertyName)) ? null : modelAndMapping.mapping.tryGetFieldMapping(property.getName());
        return new ModelAndProp(modelAndMapping, property, field);
    }

    protected void applyFieldFilter(WhereBuilder.Expr expr, String alias, FieldMapping fm, Object value, String op) {
        expr.append(alias).append('.').append(fm.getFieldName()).append(' ').append(op).append(" ?");
        expr.arg(Converts.convert((Object)value, (Class)fm.getJavaType()));
    }

    protected void applyFieldFilterExpr(WhereBuilder.Expr expr, String alias, FieldMapping fm, String filterExpr, String op) {
        expr.append(alias).append('.').append(fm.getFieldName()).append(' ').append(op).append(" ").append(filterExpr);
    }

    protected void applyFieldFilterIn(WhereBuilder.Expr expr, String alias, FieldMapping fm, String[] values) {
        expr.append(alias).append('.').append(fm.getFieldName()).append(' ').append("in").append(" ?");
        expr.arg(Converts.convert((Object)values, Array.newInstance(fm.getJavaType(), 0).getClass()));
    }

    protected void applyFieldFilterIn(WhereBuilder.Expr expr, String alias, FieldMapping fm, List<ScelNode> values, String sqlOperator) {
        expr.append(alias).append('.').append(fm.getFieldName()).append(' ').append(sqlOperator).append(" ?");
        Class type = fm.getJavaType();
        Object[] args = new Object[values.size()];
        for (int i = 0; i < args.length; ++i) {
            ScelNode value = values.get(i);
            args[i] = ScelToken.NULL == value.token() ? null : Converts.convert((Object)value.literal(), (Class)type);
        }
        expr.arg((Object)args);
    }

    protected String toSqlOperator(ScelToken op) {
        if (op == ScelToken.EQ) {
            return "=";
        }
        if (op == ScelToken.GE) {
            return ">=";
        }
        if (op == ScelToken.LE) {
            return "<=";
        }
        if (op == ScelToken.GT) {
            return ">";
        }
        if (op == ScelToken.LT) {
            return "<";
        }
        if (op == ScelToken.NE) {
            return "<>";
        }
        if (op == ScelToken.NOT) {
            return "not";
        }
        if (op == ScelToken.IN) {
            return "in";
        }
        if (op == ScelToken.NOT_IN) {
            return "not in";
        }
        if (op == ScelToken.LIKE || op == ScelToken.CO || op == ScelToken.SW || op == ScelToken.EW) {
            return "like";
        }
        if (op == ScelToken.IS) {
            return "is null";
        }
        if (op == ScelToken.IS_NOT || op == ScelToken.PR) {
            return "is not null";
        }
        throw new IllegalStateException("Not supported operator '" + op + "'");
    }

    protected ResolvedExpand[] resolveExpands(Expand[] expands) {
        if (null == expands) {
            return null;
        }
        ResolvedExpand[] resolvedExpands = new ResolvedExpand[expands.length];
        for (int i = 0; i < expands.length; ++i) {
            Expand expand = expands[i];
            String name = expand.getName();
            MApiProperty ap = this.am.tryGetProperty(name);
            if (null == ap) {
                throw new BadRequestException("The expand property '" + name + "' not exists!");
            }
            RelationProperty rp = this.em.tryGetRelationProperty(name);
            if (null == rp) {
                throw new BadRequestException("Property '" + name + "' cannot be expanded");
            }
            RelationMapping rm = this.em.getRelationMapping(rp.getRelationName());
            EntityMapping tem = this.dao.getOrmContext().getMetadata().tryGetEntityMapping(rp.getTargetEntityName());
            if (tem == null) {
                throw new IllegalStateException("Can't find target entity '" + rp.getTargetEntityName() + "'");
            }
            resolvedExpands[i] = new ResolvedExpand(expand, rp, rm, tem);
        }
        return resolvedExpands;
    }

    protected static class ResolvedExpand {
        protected final String name;
        protected final String select;
        protected final RelationProperty rp;
        protected final RelationMapping rm;
        protected final EntityMapping tem;

        public ResolvedExpand(Expand expand, RelationProperty rp, RelationMapping rm, EntityMapping tem) {
            this.name = expand.getName();
            this.select = expand.getSelect();
            this.rp = rp;
            this.rm = rm;
            this.tem = tem;
        }

        public String getName() {
            return this.name;
        }

        public String getSelect() {
            return this.select;
        }

        public boolean isRemoteRest() {
            return this.tem.isRemoteRest();
        }

        public boolean isEmbedded() {
            return this.rm.isEmbedded();
        }
    }

    protected static class ModelAndProp
    extends ModelAndMapping {
        final MApiProperty property;
        final FieldMapping field;

        public ModelAndProp(ModelAndMapping mm, MApiProperty property, FieldMapping field) {
            super(mm.model, mm.mapping);
            this.property = property;
            this.field = field;
        }
    }

    protected static class ModelAndMapping {
        public final MApiModel model;
        public final EntityMapping mapping;

        public ModelAndMapping(MApiModel model, EntityMapping mapping) {
            this.model = model;
            this.mapping = mapping;
        }
    }

    protected static class JoinModels {
        private final Map<String, ModelAndMapping> m = new SimpleCaseInsensitiveMap();

        public JoinModels() {
        }

        public JoinModels(String alias, ModelAndMapping join) {
            this.add(alias, join);
        }

        public void add(String alias, ModelAndMapping join) {
            this.m.put(alias, join);
        }

        public ModelAndMapping get(String alias) {
            return this.m.get(alias);
        }

        public boolean isEmpty() {
            return !this.m.isEmpty();
        }

        public boolean contains(String alias) {
            return this.m.containsKey(alias);
        }
    }
}

