/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import leap.core.annotation.Inject;
import leap.lang.Arrays2;
import leap.lang.annotation.Init;
import leap.web.api.orm.DefaultModelCreateExecutor;
import leap.web.api.orm.DefaultModelDeleteExecutor;
import leap.web.api.orm.DefaultModelQueryExecutor;
import leap.web.api.orm.DefaultModelUpdateExecutor;
import leap.web.api.orm.DefaultRelationQueryExecutor;
import leap.web.api.orm.ModelCreateExecutor;
import leap.web.api.orm.ModelCreateExtension;
import leap.web.api.orm.ModelCreateHandler;
import leap.web.api.orm.ModelCreateInterceptor;
import leap.web.api.orm.ModelDeleteExecutor;
import leap.web.api.orm.ModelDeleteExtension;
import leap.web.api.orm.ModelDeleteHandler;
import leap.web.api.orm.ModelDeleteInterceptor;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelExecutorFactory;
import leap.web.api.orm.ModelFindInterceptor;
import leap.web.api.orm.ModelFindToQueryInterceptor;
import leap.web.api.orm.ModelQueryExecutor;
import leap.web.api.orm.ModelQueryExtension;
import leap.web.api.orm.ModelQueryHandler;
import leap.web.api.orm.ModelQueryInterceptor;
import leap.web.api.orm.ModelReplaceInterceptor;
import leap.web.api.orm.ModelUpdateExecutor;
import leap.web.api.orm.ModelUpdateExtension;
import leap.web.api.orm.ModelUpdateHandler;
import leap.web.api.orm.ModelUpdateInterceptor;
import leap.web.api.orm.RelationExecutorContext;
import leap.web.api.orm.RelationQueryExecutor;
import leap.web.api.orm.RelationQueryExtension;
import leap.web.api.orm.RelationQueryInterceptor;
import leap.web.api.remote.RestResourceFactory;

public class DefaultModelExecutorFactory
implements ModelExecutorFactory {
    @Inject
    protected ModelCreateHandler createHandler;
    @Inject
    protected ModelCreateInterceptor[] createInterceptors;
    @Inject
    protected ModelUpdateHandler updateHandler;
    @Inject
    protected ModelUpdateInterceptor[] updateInterceptors;
    @Inject
    protected ModelReplaceInterceptor[] replaceInterceptors;
    @Inject
    protected ModelQueryHandler queryHandler;
    @Inject
    protected ModelQueryInterceptor[] queryInterceptors;
    @Inject
    protected ModelDeleteHandler deleteHandler;
    @Inject
    protected ModelDeleteInterceptor[] deleteInterceptors;
    @Inject
    protected RelationQueryInterceptor[] relationQueryInterceptors;
    @Inject
    protected RestResourceFactory restResourceFactory;
    private ModelCreateExtension createExtension;
    private ModelUpdateExtension updateExtension;
    private ModelQueryExtension queryExtension;
    private ModelDeleteExtension deleteExtension;
    private RelationQueryExtension relationQueryExtension;

    @Init
    private void init() {
        this.createExtension = new ModelCreateExtension(this.createHandler, this.createInterceptors);
        this.updateExtension = new ModelUpdateExtension(this.updateHandler, this.updateInterceptors, this.replaceInterceptors);
        this.queryExtension = new ModelQueryExtension(this.queryHandler, this.queryInterceptors);
        this.deleteExtension = new ModelDeleteExtension(this.deleteHandler, this.deleteInterceptors);
        this.relationQueryExtension = new RelationQueryExtension(this.relationQueryInterceptors);
    }

    @Override
    public ModelCreateExecutor newCreateExecutor(ModelExecutorContext context, ModelCreateInterceptor ... interceptors) {
        ModelCreateExtension extension = Arrays2.isEmpty((Object[])interceptors) ? this.createExtension : new ModelCreateExtension(this.createHandler, (ModelCreateInterceptor[])Arrays2.concat((Object[])interceptors, (Object[])this.createInterceptors));
        return new DefaultModelCreateExecutor(this.handleContext(context), extension);
    }

    @Override
    public ModelUpdateExecutor newUpdateExecutor(ModelExecutorContext context, ModelUpdateInterceptor ... interceptors) {
        ModelUpdateExtension extension = Arrays2.isEmpty((Object[])interceptors) ? this.updateExtension : new ModelUpdateExtension(this.updateHandler, (ModelUpdateInterceptor[])Arrays2.concat((Object[])interceptors, (Object[])this.updateInterceptors), this.replaceInterceptors);
        return new DefaultModelUpdateExecutor(this.handleContext(context), extension);
    }

    @Override
    public ModelDeleteExecutor newDeleteExecutor(ModelExecutorContext context, ModelDeleteInterceptor ... interceptors) {
        ModelDeleteExtension extension = Arrays2.isEmpty((Object[])interceptors) ? this.deleteExtension : new ModelDeleteExtension(this.deleteHandler, (ModelDeleteInterceptor[])Arrays2.concat((Object[])interceptors, (Object[])this.deleteInterceptors));
        return new DefaultModelDeleteExecutor(this.handleContext(context), extension);
    }

    @Override
    public ModelQueryExecutor newQueryExecutor(ModelExecutorContext context, ModelQueryInterceptor ... interceptors) {
        ModelQueryExtension extension = Arrays2.isEmpty((Object[])interceptors) ? this.queryExtension : new ModelQueryExtension(this.queryHandler, (ModelQueryInterceptor[])Arrays2.concat((Object[])interceptors, (Object[])this.queryInterceptors));
        return new DefaultModelQueryExecutor(this.handleContext(context), extension);
    }

    @Override
    public ModelQueryExecutor newQueryExecutor(ModelExecutorContext context, ModelFindInterceptor ... interceptors) {
        return this.newQueryExecutor(context, ModelFindToQueryInterceptor.of(interceptors));
    }

    @Override
    public RelationQueryExecutor newRelationQueryExecutor(RelationExecutorContext context, RelationQueryInterceptor ... interceptors) {
        RelationQueryExtension extension = Arrays2.isEmpty((Object[])interceptors) ? this.relationQueryExtension : new RelationQueryExtension((RelationQueryInterceptor[])Arrays2.concat((Object[])interceptors, (Object[])this.relationQueryInterceptors));
        return new DefaultRelationQueryExecutor(this.handleContext(context), extension);
    }

    protected <T extends ModelExecutorContext> T handleContext(T context) {
        context.setRestResourceFactory(this.restResourceFactory);
        return context;
    }
}

