/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import leap.orm.event.EntityListeners;
import leap.orm.mapping.EntityMapping;
import leap.web.api.mvc.params.DeleteOptions;
import leap.web.api.orm.DefaultModelExecutionContext;
import leap.web.api.orm.DeleteOneResult;
import leap.web.api.orm.ModelDeleteExecutor;
import leap.web.api.orm.ModelDeleteExtension;
import leap.web.api.orm.ModelExecutorBase;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.remote.RestResource;

public class DefaultModelDeleteExecutor
extends ModelExecutorBase
implements ModelDeleteExecutor {
    protected final ModelDeleteExtension ex;
    private ModelDeleteExecutor.DeleteHandler handler;
    private EntityListeners listeners;

    public DefaultModelDeleteExecutor(ModelExecutorContext context, ModelDeleteExtension ex) {
        super(context);
        this.ex = null == ex ? ModelDeleteExtension.EMPTY : ex;
    }

    @Override
    public ModelDeleteExecutor withHandler(ModelDeleteExecutor.DeleteHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public ModelDeleteExecutor withListeners(EntityListeners listeners) {
        this.listeners = listeners;
        return this;
    }

    @Override
    public DeleteOneResult deleteOne(Object id, DeleteOptions options) {
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        if (null == options) {
            options = new DeleteOptions();
        }
        this.ex.processDeleteOneOptions(context, id, options);
        this.ex.processDeleteOneOptions((ModelExecutorContext)context, id, options);
        try {
            Object entity;
            DeleteOneResult r;
            DeleteOneResult result;
            this.ex.preDeleteOne(context, id);
            if (null != this.ex.handler) {
                this.ex.handler.processDeleteOptions(context, id, options);
                result = this.ex.handler.handleDeleteExecution(context, id, options);
            } else {
                result = this.ex.handleDeleteOne(context, id, options);
            }
            if (null == result) {
                if (!this.em.isRemoteRest()) {
                    DeleteOptions finalOptions = options;
                    result = (DeleteOneResult)EntityMapping.withContextListeners((EntityListeners)this.listeners, () -> {
                        if (null != this.handler) {
                            return new DeleteOneResult(this.handler.deleteOne(context, id, finalOptions) > 0);
                        }
                        if (!finalOptions.isCascadeDelete()) {
                            return (DeleteOneResult)this.dao.withEvents(() -> new DeleteOneResult(this.dao.delete(this.em, id) > 0));
                        }
                        return (DeleteOneResult)this.dao.withEvents(() -> new DeleteOneResult(this.dao.cascadeDelete(this.em, id)));
                    });
                } else {
                    RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
                    result = restResource.delete(id, options) ? new DeleteOneResult(true) : new DeleteOneResult(false);
                }
            }
            if (null != this.ex.handler && null != (r = this.ex.handler.postDeleteRecord(context, id, options, result))) {
                result = r;
            }
            if (null != (entity = this.ex.processDeleteOneResult(context, id, result.success))) {
                result = new DeleteOneResult(result.success, entity);
            }
            this.ex.completeDeleteOne(context, result, null);
            return result;
        }
        catch (Throwable e) {
            this.ex.completeDeleteOne(context, null, e);
            throw e;
        }
    }
}

