/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.orm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import leap.core.validation.Errors;
import leap.core.validation.ValidationException;
import leap.core.value.Record;
import leap.lang.Beans;
import leap.lang.Enumerable;
import leap.lang.Enumerables;
import leap.lang.New;
import leap.orm.command.InsertCommand;
import leap.orm.event.EntityListeners;
import leap.orm.mapping.EntityMapping;
import leap.orm.mapping.Mappings;
import leap.orm.mapping.RelationMapping;
import leap.orm.mapping.RelationProperty;
import leap.web.api.meta.model.MApiProperty;
import leap.web.api.mvc.params.Partial;
import leap.web.api.orm.CreateOneResult;
import leap.web.api.orm.DefaultModelExecutionContext;
import leap.web.api.orm.ModelCreateExecutor;
import leap.web.api.orm.ModelCreateExtension;
import leap.web.api.orm.ModelExecutorBase;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.remote.RestResource;
import leap.web.exception.BadRequestException;

public class DefaultModelCreateExecutor
extends ModelExecutorBase
implements ModelCreateExecutor {
    protected final ModelCreateExtension ex;
    protected ModelCreateExecutor.CreateHandler createOneHandler;
    protected EntityListeners listeners;

    public DefaultModelCreateExecutor(ModelExecutorContext context, ModelCreateExtension ex) {
        super(context);
        this.ex = null == ex ? ModelCreateExtension.EMPTY : ex;
    }

    @Override
    public ModelCreateExecutor withHandler(ModelCreateExecutor.CreateHandler handler) {
        this.createOneHandler = handler;
        return this;
    }

    @Override
    public ModelCreateExecutor withListeners(EntityListeners listeners) {
        this.listeners = listeners;
        return this;
    }

    @Override
    public CreateOneResult createOne(Object request, Object id, Map<String, Object> extraProperties) {
        Object entity;
        Map properties;
        Object r;
        DefaultModelExecutionContext context = new DefaultModelExecutionContext(this.context);
        Object v = this.ex.processCreationParams(context, request);
        if (null != v) {
            request = v;
        }
        if (null != this.ex.handler && null != (r = this.ex.handler.processCreationParams(context, request))) {
            request = r;
        }
        if ((properties = request instanceof Partial ? ((Partial)request).getProperties() : (request instanceof Map ? (Map)request : Beans.toMap((Object)request))).isEmpty()) {
            throw new BadRequestException("No create properties!");
        }
        if (null != extraProperties) {
            properties.putAll(extraProperties);
        }
        this.ex.processCreationRecord(context, properties);
        if (null != this.ex.handler) {
            this.ex.handler.processCreationRecord(context, properties);
        }
        LinkedHashMap<RelationProperty, Object[]> relationProperties = new LinkedHashMap<RelationProperty, Object[]>();
        HashSet<String> removes = new HashSet<String>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            MApiProperty p = this.am.tryGetProperty(name);
            if (null == p) {
                if (this.ex.handleCreationPropertyNotFound(context, name, entry.getValue(), removes)) continue;
                throw new BadRequestException("Property '" + name + "' not exists!");
            }
            if (p.isNotCreatableExplicitly()) {
                if (null == properties.get(name)) {
                    removes.add(name);
                } else {
                    if (this.ex.handleCreationPropertyReadonly(context, name, entry.getValue(), removes)) continue;
                    throw new BadRequestException("Property '" + name + "' is not creatable!");
                }
            }
            if (null != p.getMetaProperty() && p.getMetaProperty().isReference()) {
                v = properties.get(name);
                if (null == v) continue;
                RelationProperty rp = this.em.getRelationProperty(name);
                Enumerable e = Enumerables.tryOf((Object)v);
                if (null == e) {
                    relationProperties.put(rp, new Object[]{v});
                } else {
                    relationProperties.put(rp, e.toArray());
                }
            }
            this.tryHandleSpecialValue(entry, p);
        }
        removes.forEach(properties::remove);
        Errors errors = this.dao.validate(this.em, (Object)properties);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
        this.ex.preCreateRecord(context, properties);
        if (null != this.ex.handler) {
            this.ex.handler.preCreateRecord(context, properties);
        }
        CreationImpl creationImpl = new CreationImpl(id, properties, relationProperties);
        Object createdId = null;
        Record record = null;
        if (!this.em.isRemoteRest()) {
            createdId = EntityMapping.withContextListeners((EntityListeners)this.listeners, () -> {
                if (null != this.createOneHandler) {
                    return this.createOneHandler.create(context, creation);
                }
                return this.createByDb(creation);
            });
            if (null != createdId) {
                record = this.dao.find(this.em, createdId);
            }
        } else {
            RestResource restResource = this.restResourceFactory.createResource(this.dao.getOrmContext(), this.em);
            record = restResource.create(properties);
            createdId = Mappings.getId((EntityMapping)this.em, (Map)record);
        }
        if (null == createdId) {
            return new CreateOneResult(null, null);
        }
        if (null != record) {
            record.put((Object)"$id", createdId);
        }
        if (null != (entity = this.ex.postCreateRecord(context, createdId, record))) {
            return new CreateOneResult(createdId, entity);
        }
        return new CreateOneResult(createdId, record);
    }

    protected void executeInsert(InsertCommand insert) {
        this.dao.withEvents(() -> insert.execute());
        if (null != this.ex.handler) {
            this.ex.handler.postCreateRecord(this.context, insert.id());
        }
    }

    protected Object createByDb(CreationImpl creation) {
        InsertCommand insert = this.dao.cmdInsert(this.em.getEntityName()).from(creation.getProperties());
        if (null != creation.getId()) {
            insert.withId(creation.getId());
        }
        if (creation.getRelationProperties().isEmpty()) {
            this.executeInsert(insert);
        } else {
            this.dao.doTransaction(conn -> {
                this.executeInsert(insert);
                for (Map.Entry<RelationProperty, Object[]> entry : creation.getRelationProperties().entrySet()) {
                    String targetName;
                    String localName;
                    RelationProperty rp = entry.getKey();
                    RelationMapping rm = this.em.getRelationMapping(rp.getRelationName());
                    if (!rm.isManyToMany()) continue;
                    EntityMapping joinEntity = this.md.getEntityMapping(rm.getJoinEntityName());
                    RelationMapping manyToOne1 = joinEntity.tryGetKeyRelationMappingOfTargetEntity(this.em.getEntityName());
                    if (joinEntity.getKeyFieldMappings()[0].getFieldName().equals(manyToOne1.getJoinFields()[0].getLocalFieldName())) {
                        localName = joinEntity.getKeyFieldNames()[0];
                        targetName = joinEntity.getKeyFieldNames()[1];
                    } else {
                        localName = joinEntity.getKeyFieldNames()[1];
                        targetName = joinEntity.getKeyFieldNames()[0];
                    }
                    Object localId = insert.id();
                    ArrayList<HashMap> batchId = new ArrayList<HashMap>();
                    for (Object targetId : entry.getValue()) {
                        batchId.add(New.hashMap((Object)localName, (Object)localId, (Object)targetName, (Object)targetId));
                    }
                    this.dao.batchInsert(joinEntity, batchId);
                }
            });
        }
        return insert.id();
    }

    protected static class CreationImpl
    implements ModelCreateExecutor.CreateParams {
        private final Object id;
        private final Map<String, Object> properties;
        private final Map<RelationProperty, Object[]> relationProperties;

        public CreationImpl(Object id, Map<String, Object> properties, Map<RelationProperty, Object[]> relationProperties) {
            this.id = id;
            this.properties = properties;
            this.relationProperties = relationProperties;
        }

        public Object getId() {
            return this.id;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Override
        public Map<RelationProperty, Object[]> getRelationProperties() {
            return this.relationProperties;
        }

        @Override
        public Map<String, Object> getCombinedProperties() {
            if (null == this.relationProperties || this.relationProperties.isEmpty()) {
                return this.properties;
            }
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>(this.properties);
            this.relationProperties.forEach((rp, vals) -> {
                if (((Object[])vals).length == 0) {
                    return;
                }
                if (rp.isMany()) {
                    m.put(rp.getName(), vals);
                } else {
                    if (((Object[])vals).length > 1) {
                        throw new IllegalStateException("Found multi values fo to-one relation property '" + rp.getName() + "'");
                    }
                    m.put(rp.getName(), vals[0]);
                }
            });
            return m;
        }
    }
}

