/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.mvc.params;

import java.util.HashMap;
import java.util.Map;
import leap.lang.Strings;
import leap.lang.json.JsonIgnore;
import leap.lang.text.scel.ScelExpr;
import leap.lang.value.Page;
import leap.web.annotation.NonParam;
import leap.web.annotation.ParamsWrapper;
import leap.web.annotation.QueryParam;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.query.Aggregate;
import leap.web.api.query.AggregateParser;
import leap.web.api.query.FiltersParser;
import leap.web.api.query.GroupBy;
import leap.web.api.query.GroupByParser;
import leap.web.api.query.Join;
import leap.web.api.query.JoinParser;
import leap.web.api.query.OrderBy;
import leap.web.api.query.OrderByParser;
import leap.web.api.query.Select;
import leap.web.api.query.SelectParser;
import leap.web.exception.BadRequestException;

@ParamsWrapper
public class QueryOptions
extends QueryOptionsBase {
    @QueryParam(value="page_size")
    protected Integer pageSize;
    @QueryParam(value="page")
    protected Integer pageIndex;
    @QueryParam(value="limit")
    protected Integer limit;
    @QueryParam(value="offset")
    protected Integer offset;
    @QueryParam(value="total")
    protected boolean total;
    @QueryParam(value="orderby")
    protected String orderBy;
    @QueryParam(value="viewId")
    protected String viewId;
    @QueryParam(value="filters")
    protected String filters;
    @QueryParam(value="aggregates")
    protected String aggregates;
    @QueryParam(value="groupby")
    protected String groupBy;
    @QueryParam(value="joins")
    protected String joins;
    @NonParam
    @JsonIgnore
    protected ScelExpr resolvedFilters;
    @NonParam
    @JsonIgnore
    protected OrderBy resolvedOrderBy;
    @NonParam
    @JsonIgnore
    protected Aggregate resolvedAggregate;
    @NonParam
    @JsonIgnore
    protected GroupBy resolvedGroupBy;
    @NonParam
    @JsonIgnore
    protected Select resolvedSelect;
    @NonParam
    @JsonIgnore
    protected Join[] resolvedJoins;
    @NonParam
    @JsonIgnore
    protected Map<String, Object> queryParams;
    @NonParam
    @JsonIgnore
    protected Boolean allowSingleExpr;

    public boolean getAllowSingleExpr() {
        return null == this.allowSingleExpr ? false : this.allowSingleExpr;
    }

    public void setAllowSingleExpr(boolean allowSingleExpr) {
        this.allowSingleExpr = allowSingleExpr;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage_size(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPage(Integer page) {
        this.pageIndex = page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean isTotal() {
        return this.total;
    }

    public void setTotal(boolean total) {
        this.total = total;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setOrderby(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public String getAggregates() {
        return this.aggregates;
    }

    public void setAggregates(String aggregates) {
        this.aggregates = aggregates;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public void setGropuby(String gropuby) {
        this.groupBy = gropuby;
    }

    public String getJoins() {
        return this.joins;
    }

    public void setJoins(String joins) {
        this.joins = joins;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Map<String, Object> queryParams) {
        this.queryParams = queryParams;
    }

    public void setQueryParam(String name, Object value) {
        if (null == this.queryParams) {
            this.queryParams = new HashMap<String, Object>();
        }
        this.queryParams.put(name, value);
    }

    public Page getPage(int defaultPageSize) {
        if (null != this.limit || null != this.offset) {
            if (null == this.limit) {
                return Page.limit((int)defaultPageSize, (int)this.offset);
            }
            return Page.limit((int)this.limit, (int)(null == this.offset ? 0 : this.offset));
        }
        if (null != this.pageIndex || null != this.pageSize) {
            if (null == this.pageIndex) {
                return Page.indexOf((int)1, (int)this.pageSize);
            }
            return Page.indexOf((int)this.pageIndex, (int)(null == this.pageSize ? defaultPageSize : this.pageSize));
        }
        return Page.indexOf((int)1, (int)defaultPageSize);
    }

    public ScelExpr getResolvedFilters() {
        if (null == this.resolvedFilters && !Strings.isEmpty((String)this.filters)) {
            try {
                this.resolvedFilters = FiltersParser.parse(this.filters, this.getAllowSingleExpr());
            }
            catch (Exception e) {
                throw new BadRequestException("Invalid filter expr '" + this.filters + "', " + e.getMessage(), (Throwable)e);
            }
        }
        return this.resolvedFilters;
    }

    public void setResolvedFilters(ScelExpr resolvedFilters) {
        this.resolvedFilters = resolvedFilters;
    }

    public OrderBy getResolvedOrderBy() {
        if (null == this.resolvedOrderBy && !Strings.isEmpty((String)this.orderBy)) {
            this.resolvedOrderBy = OrderByParser.parse(this.orderBy);
        }
        return this.resolvedOrderBy;
    }

    public void setResolvedOrderBy(OrderBy resolvedOrderBy) {
        this.resolvedOrderBy = resolvedOrderBy;
    }

    public GroupBy getResolvedGroupBy() {
        if (null == this.resolvedGroupBy && Strings.isNotEmpty((String)this.groupBy)) {
            this.resolvedGroupBy = GroupByParser.parse(this.groupBy);
        }
        return this.resolvedGroupBy;
    }

    public void setResolvedGroupBy(GroupBy resolvedGroupBy) {
        this.resolvedGroupBy = resolvedGroupBy;
    }

    public Aggregate getResolvedAggregate() {
        if (null == this.resolvedAggregate && Strings.isNotEmpty((String)this.aggregates)) {
            this.resolvedAggregate = AggregateParser.parse(this.aggregates, this.getAllowSingleExpr());
        }
        return this.resolvedAggregate;
    }

    public void setResolvedAggregate(Aggregate resolvedAggregate) {
        this.resolvedAggregate = resolvedAggregate;
    }

    public Select getResolvedSelect() {
        if (null == this.resolvedSelect && Strings.isNotEmpty((String)this.select)) {
            this.resolvedSelect = SelectParser.parse(this.select);
        }
        return this.resolvedSelect;
    }

    public void setResolvedSelect(Select resolvedSelect) {
        this.resolvedSelect = resolvedSelect;
    }

    public Join[] getResolvedJoins() {
        if (null == this.resolvedJoins && !Strings.isEmpty((String)this.joins)) {
            this.resolvedJoins = JoinParser.parse(this.joins);
        }
        return this.resolvedJoins;
    }

    public void setResolvedJoins(Join[] resolvedJoins) {
        this.resolvedJoins = resolvedJoins;
    }

    public void clearResolved() {
        this.resolvedJoins = null;
        this.resolvedOrderBy = null;
        this.resolvedFilters = null;
        this.resolvedExpands = null;
    }
}

