/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.mvc;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import leap.core.annotation.Inject;
import leap.lang.Types;
import leap.orm.OrmMetadata;
import leap.orm.dao.Dao;
import leap.orm.mapping.EntityMapping;
import leap.orm.query.CriteriaQuery;
import leap.web.api.Api;
import leap.web.api.annotation.ResourceWrapper;
import leap.web.api.config.ApiConfig;
import leap.web.api.meta.ApiMetadata;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.mvc.ApiController;
import leap.web.api.mvc.ApiInitializable;
import leap.web.api.mvc.ApiResponse;
import leap.web.api.mvc.params.DeleteOptions;
import leap.web.api.mvc.params.FindOptions;
import leap.web.api.mvc.params.Partial;
import leap.web.api.mvc.params.QueryOptions;
import leap.web.api.mvc.params.QueryOptionsBase;
import leap.web.api.orm.ModelCreateExecutor;
import leap.web.api.orm.ModelDeleteExecutor;
import leap.web.api.orm.ModelExecutorContext;
import leap.web.api.orm.ModelExecutorFactory;
import leap.web.api.orm.ModelQueryExecutor;
import leap.web.api.orm.ModelUpdateExecutor;
import leap.web.api.orm.QueryListResult;
import leap.web.api.orm.QueryOneResult;
import leap.web.api.orm.SimpleModelExecutorContext;
import leap.web.api.orm.UpdateOneResult;

@ResourceWrapper
public abstract class ModelController<T>
extends ApiController
implements ApiInitializable {
    @Inject
    protected ModelExecutorFactory mef;
    protected final Class<T> modelClass = this.getModelClass();
    protected final Dao dao = Dao.of(this.modelClass);
    protected final OrmMetadata md = this.dao.getOrmContext().getMetadata();
    protected final EntityMapping em = this.md.getEntityMapping(this.modelClass);
    protected ApiConfig ac;
    protected ApiMetadata amd;
    protected MApiModel am;
    protected ModelExecutorContext mec;

    private Class<T> getModelClass() {
        return Types.getActualTypeArgument((Type)this.getClass().getGenericSuperclass());
    }

    @Override
    public void postApiInitialized(Api api) {
        this.ac = api.getConfig();
        this.amd = api.getMetadata();
        this.am = api.getMetadata().getModel(this.modelClass);
        this.mec = new SimpleModelExecutorContext(api, this.dao, this.am, this.em, null);
    }

    protected ApiResponse create(Object request) {
        return this.create(request, null);
    }

    protected ApiResponse create(Object request, Object id) {
        this.createRecordAndReturnId(request, id);
        return ApiResponse.OK;
    }

    protected ApiResponse createAndReturn(Object request) {
        return this.createAndReturn(request, null);
    }

    protected ApiResponse createAndReturn(Object request, Object id) {
        id = this.createRecordAndReturnId(request, id);
        return ApiResponse.created(this.dao.findOrNull(this.em, id));
    }

    protected ApiResponse createAndReturn(Object request, Map<String, Object> extraProperties) {
        Object id = this.createRecordAndReturnId(request, null, extraProperties);
        return ApiResponse.created(this.dao.findOrNull(this.em, id));
    }

    protected ApiResponse createAndReturn(Object request, Object id, Map<String, Object> extraProperties) {
        id = this.createRecordAndReturnId(request, id, extraProperties);
        return ApiResponse.created(this.dao.findOrNull(this.em, id));
    }

    protected Object createRecordAndReturnId(Object request, Object id) {
        return this.createRecordAndReturnId(request, id, null);
    }

    protected Object createRecordAndReturnId(Object request, Object id, Map<String, Object> extraProperties) {
        ModelCreateExecutor executor = this.mef.newCreateExecutor(this.mec);
        return executor.createOne((Object)request, (Object)id, extraProperties).id;
    }

    protected ApiResponse find(Object id) {
        return this.get(id);
    }

    protected ApiResponse find(Object id, FindOptions options) {
        return this.get(id, options);
    }

    protected ApiResponse get(Object id) {
        return ApiResponse.of(this.dao.findOrNull(this.em, id));
    }

    protected ApiResponse get(Object id, QueryOptionsBase options) {
        ModelQueryExecutor executor = this.mef.newQueryExecutor(this.mec);
        QueryOneResult result = executor.queryOne(id, options);
        return ApiResponse.of(result.getRecord());
    }

    protected ApiResponse<List<T>> getAll(QueryOptions options) {
        return this.queryList(options);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options) {
        return this.queryList(options, null, null, null);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, boolean filterByParams) {
        return this.queryList(options, null, null, null, filterByParams);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, Consumer<CriteriaQuery> callback) {
        return this.queryList(options, null, null, callback);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, Consumer<CriteriaQuery> callback, boolean filterByParams) {
        return this.queryList(options, null, null, callback, filterByParams);
    }

    protected ApiResponse<List<T>> queryListWithExecutorCallback(QueryOptions options, Consumer<ModelQueryExecutor> callback) {
        return this.queryList(options, null, callback, null);
    }

    protected ApiResponse<List<T>> queryListWithExecutorCallback(QueryOptions options, Consumer<ModelQueryExecutor> callback, boolean filterByParams) {
        return this.queryList(options, null, callback, null, filterByParams);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, Map<String, Object> filters) {
        return this.queryList(options, filters, null, null);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, Map<String, Object> filters, boolean filterByParams) {
        return this.queryList(options, filters, null, null, filterByParams);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, Map<String, Object> filters, Consumer<ModelQueryExecutor> executorCallback, Consumer<CriteriaQuery> queryCallback) {
        return this.queryList(options, filters, executorCallback, queryCallback, true);
    }

    protected ApiResponse<List<T>> queryList(QueryOptions options, Map<String, Object> filters, Consumer<ModelQueryExecutor> executorCallback, Consumer<CriteriaQuery> queryCallback, boolean filterByParams) {
        QueryListResult result;
        ModelQueryExecutor executor = this.mef.newQueryExecutor(this.mec);
        if (null != executorCallback) {
            executorCallback.accept(executor);
        }
        if ((result = executor.queryList(options, filters, queryCallback, filterByParams)).getCount() == -1L) {
            return ApiResponse.of(result.getList());
        }
        return ApiResponse.of(result.getList()).setHeader("X-Total-Count", String.valueOf(result.getCount()));
    }

    protected ApiResponse updatePartial(Object id, Partial<T> partial) {
        ModelUpdateExecutor executor = this.mef.newUpdateExecutor(this.mec);
        UpdateOneResult result = executor.partialUpdateOne(id, partial);
        if (result.affectedRows > 0) {
            return ApiResponse.NO_CONTENT;
        }
        return ApiResponse.NOT_FOUND;
    }

    protected ApiResponse delete(Object id) {
        if (this.dao.delete(this.modelClass, id) > 0) {
            return ApiResponse.NO_CONTENT;
        }
        return ApiResponse.NOT_FOUND;
    }

    protected ApiResponse cascadeDelete(Object id) {
        if (this.dao.cascadeDelete(this.modelClass, id)) {
            return ApiResponse.NO_CONTENT;
        }
        return ApiResponse.NOT_FOUND;
    }

    protected ApiResponse delete(Object id, DeleteOptions options) {
        ModelDeleteExecutor executor = this.mef.newDeleteExecutor(this.mec);
        if (executor.deleteOne((Object)id, (DeleteOptions)options).success) {
            return ApiResponse.NO_CONTENT;
        }
        return ApiResponse.NOT_FOUND;
    }
}

