/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.mvc;

import java.util.NoSuchElementException;
import leap.core.annotation.Inject;
import leap.core.exception.EmptyRecordsException;
import leap.core.exception.RecordNotFoundException;
import leap.core.validation.Errors;
import leap.core.validation.ValidationException;
import leap.lang.NamedError;
import leap.lang.exception.ObjectExistsException;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.http.HTTP;
import leap.web.Response;
import leap.web.Result;
import leap.web.action.ActionContext;
import leap.web.action.ActionExecution;
import leap.web.api.mvc.ApiErrorHandler;
import leap.web.api.mvc.ApiExceptionHandler;
import leap.web.api.mvc.ApiFailureHandler;
import leap.web.api.mvc.ApiResponseException;
import leap.web.exception.ResponseException;

public class DefaultApiFailureHandler
implements ApiFailureHandler {
    @Inject
    protected ApiErrorHandler errorHandler;
    @Inject
    protected ApiExceptionHandler[] exceptionHandlers;

    public DefaultApiFailureHandler() {
    }

    public DefaultApiFailureHandler(ApiErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean handleFailure(ActionContext context, ActionExecution execution, Result result) {
        Response response = context.getResponse();
        ApiErrorHandler errorHandler = this.getErrorHandler(context);
        if (execution.isValidationError()) {
            this.handleValidationError(errorHandler, response, execution.getValidation().errors());
            return true;
        }
        if (execution.hasException()) {
            Throwable e = execution.getException();
            for (ApiExceptionHandler handler : this.exceptionHandlers) {
                if (!handler.handleApiException(errorHandler, context, execution, response, e)) continue;
                return true;
            }
            if (this.handleException(errorHandler, response, e)) {
                return true;
            }
            errorHandler.internalServerError(response, e.getMessage());
            return true;
        }
        errorHandler.internalServerError(response, "Execution failed.");
        return true;
    }

    protected boolean handleException(ApiErrorHandler errorHandler, Response response, Throwable e) {
        if (e instanceof ValidationException) {
            Errors errors = ((ValidationException)e).getErrors();
            this.handleValidationError(errorHandler, response, errors);
            return true;
        }
        if (e instanceof ApiResponseException) {
            ApiResponseException ex = (ApiResponseException)((Object)e);
            errorHandler.responseError(response, ex.getStatus(), ex.getCode(), ex.getMessage());
            return true;
        }
        if (e instanceof ResponseException) {
            int code = ((ResponseException)e).getStatus();
            HTTP.Status status = HTTP.Status.valueOf((int)code);
            errorHandler.responseError(response, code, status.name(), e.getMessage());
            return true;
        }
        if (e instanceof ObjectExistsException) {
            errorHandler.badRequest(response, e.getMessage());
            return true;
        }
        if (e instanceof ObjectNotFoundException) {
            errorHandler.notFound(response, e.getMessage());
            return true;
        }
        if (e instanceof RecordNotFoundException) {
            errorHandler.notFound(response, e.getMessage());
            return true;
        }
        if (e instanceof EmptyRecordsException) {
            errorHandler.notFound(response, e.getMessage());
            return true;
        }
        if (e instanceof NoSuchElementException) {
            errorHandler.notFound(response, e.getMessage());
            return true;
        }
        if (e instanceof IllegalArgumentException) {
            errorHandler.badRequest(response, e.getMessage());
            return true;
        }
        if (e instanceof UnsupportedOperationException) {
            errorHandler.responseError(response, HTTP.SC_NOT_IMPLEMENTED, e.getMessage());
            return true;
        }
        return false;
    }

    protected void handleValidationError(ApiErrorHandler errorHandler, Response response, Errors errors) {
        NamedError error = errors.first();
        errorHandler.badRequest(response, "Validation failed -> " + error.getName() + " : " + error.getMessage());
    }

    protected ApiErrorHandler getErrorHandler(ActionContext context) {
        ApiErrorHandler errorHandler = (ApiErrorHandler)context.getRequest().getAttribute(ApiErrorHandler.class.getName());
        if (null == errorHandler) {
            errorHandler = this.errorHandler;
        }
        return errorHandler;
    }
}

