/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.mvc;

import leap.lang.http.HTTP;
import leap.lang.http.client.HttpHeaders;
import leap.lang.http.client.SimpleHttpHeaders;
import leap.lang.meta.annotation.TypeWrapper;
import leap.web.ResponseEntity;
import leap.web.api.mvc.ApiError;

@TypeWrapper
public class ApiResponse<T>
implements ResponseEntity {
    public static final ApiResponse OK = ApiResponse.of(HTTP.Status.OK, null);
    public static final ApiResponse ACCEPTED = ApiResponse.of(HTTP.Status.ACCEPTED, null);
    public static final ApiResponse NO_CONTENT = ApiResponse.of(HTTP.Status.NO_CONTENT, null);
    public static final ApiResponse NOT_FOUND = ApiResponse.err(HTTP.Status.NOT_FOUND, "The resource does not exists.");
    public static final ApiResponse NOT_IMPLEMENTED = ApiResponse.err(HTTP.Status.NOT_IMPLEMENTED, "Not implemented operation.");
    protected final HTTP.Status status;
    protected final Object entity;
    protected final HttpHeaders headers = new SimpleHttpHeaders();

    public static ApiResponse ok() {
        return OK;
    }

    public static ApiResponse ok(Object entity) {
        return ApiResponse.of(HTTP.Status.OK, entity);
    }

    public static ApiResponse created() {
        return ApiResponse.of(HTTP.Status.CREATED);
    }

    public static ApiResponse created(Object entity) {
        return ApiResponse.of(HTTP.Status.CREATED, entity);
    }

    public static ApiResponse accepted() {
        return ACCEPTED;
    }

    public static ApiResponse accepted(Object data) {
        return ApiResponse.of(HTTP.Status.ACCEPTED, data);
    }

    public static ApiResponse noContent() {
        return NO_CONTENT;
    }

    public static ApiResponse badRequest(String message) {
        return ApiResponse.err(HTTP.Status.BAD_REQUEST, message);
    }

    public static ApiResponse badRequest(String errorCode, String message) {
        return ApiResponse.err(HTTP.Status.BAD_REQUEST, errorCode, message);
    }

    public static ApiResponse notFound(String message) {
        return ApiResponse.err(HTTP.Status.NOT_FOUND, message);
    }

    public static ApiResponse notFound(String errorCode, String message) {
        return ApiResponse.err(HTTP.Status.NOT_FOUND, errorCode, message);
    }

    public static ApiResponse notImplemented() {
        return NOT_IMPLEMENTED;
    }

    public static ApiResponse notImplemented(String message) {
        return ApiResponse.err(HTTP.Status.NOT_IMPLEMENTED, message);
    }

    public static ApiResponse err(String message) {
        return ApiResponse.err(HTTP.Status.INTERNAL_SERVER_ERROR, message);
    }

    public static ApiResponse err(HTTP.Status status, String message) {
        return ApiResponse.of(status, (Object)new ApiError(status.name(), message));
    }

    public static ApiResponse err(int status, String message) {
        return ApiResponse.err(HTTP.Status.valueOf((int)status), message);
    }

    public static ApiResponse err(String errorCode, String message) {
        return ApiResponse.of(HTTP.Status.INTERNAL_SERVER_ERROR, (Object)new ApiError(errorCode, message));
    }

    public static ApiResponse err(HTTP.Status status, String errorCode, String message) {
        return ApiResponse.of(status, (Object)new ApiError(errorCode, message));
    }

    public static ApiResponse err(int status, String errorCode, String message) {
        return ApiResponse.err(HTTP.Status.valueOf((int)status), errorCode, message);
    }

    public static ApiResponse of(HTTP.Status status, Object entity) {
        return new ApiResponse(status, entity);
    }

    public static ApiResponse of(int status, Object entity) {
        return new ApiResponse(HTTP.Status.valueOf((int)status), entity);
    }

    public static ApiResponse of(Object entity) {
        if (null == entity) {
            return NOT_FOUND;
        }
        return ApiResponse.ok(entity);
    }

    protected ApiResponse(HTTP.Status status, Object entity) {
        this.status = status;
        this.entity = entity;
    }

    public HTTP.Status getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getEntity() {
        return this.entity;
    }

    public ApiResponse<T> setHeader(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public ApiResponse<T> withHeader(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public ApiResponse<T> addHeader(String name, String value) {
        this.headers.add(name, value);
        return this;
    }
}

