/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.mvc;

import leap.lang.http.HTTP;
import leap.web.Response;
import leap.web.api.mvc.ApiError;

public interface ApiErrorHandler {
    default public void unauthorized(Response response) {
        this.unauthorized(response, "Unauthorized");
    }

    default public void unauthorized(Response response, String message) {
        this.responseError(response, HTTP.SC_UNAUTHORIZED, HTTP.Status.UNAUTHORIZED.name(), message);
    }

    default public void forbidden(Response response) {
        this.forbidden(response, "Forbidden");
    }

    default public void forbidden(Response response, String message) {
        this.responseError(response, HTTP.SC_FORBIDDEN, HTTP.Status.FORBIDDEN.name(), message);
    }

    default public void notFound(Response response) {
        this.notFound(response, "Not found");
    }

    default public void notFound(Response response, String message) {
        this.responseError(response, HTTP.SC_NOT_FOUND, HTTP.Status.NOT_FOUND.name(), message);
    }

    default public void badRequest(Response response) {
        this.badRequest(response, "Bad request");
    }

    default public void badRequest(Response response, String message) {
        this.responseError(response, HTTP.SC_BAD_REQUEST, HTTP.Status.BAD_REQUEST.name(), message);
    }

    default public void internalServerError(Response response, String message) {
        this.responseError(response, HTTP.SC_INTERNAL_SERVER_ERROR, HTTP.Status.INTERNAL_SERVER_ERROR.name(), message);
    }

    default public void internalServerError(Response response, Throwable cause) {
        this.responseError(response, HTTP.SC_INTERNAL_SERVER_ERROR, HTTP.Status.INTERNAL_SERVER_ERROR.name(), cause.getMessage());
    }

    default public void responseError(Response response, int status, String message) {
        this.responseError(response, status, new ApiError(status, null, message));
    }

    default public void responseError(Response response, int status, String code, String message) {
        this.responseError(response, status, new ApiError(status, code, message));
    }

    public void responseError(Response var1, int var2, ApiError var3);
}

