/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.mvc;

import java.util.Map;
import leap.lang.Strings;
import leap.lang.json.JsonStringable;
import leap.lang.json.JsonWriter;
import leap.web.Renderable;
import leap.web.Request;
import leap.web.Response;

public class ApiError
implements JsonStringable,
Renderable {
    protected Integer status;
    protected String source;
    protected String code;
    protected String error;
    protected String message;
    protected Map<String, Object> details;

    public ApiError() {
    }

    public ApiError(String message) {
        this.message = message;
    }

    public ApiError(String code, String message) {
        this(null, code, message);
    }

    public ApiError(Integer status, String code, String message) {
        this.status = status;
        this.code = code;
        this.error = null == code ? null : Strings.upperCamel((String)code, (char)'_');
        this.message = message;
    }

    public void toJson(JsonWriter w) {
        w.startObject().propertyOptional("status", this.status).propertyOptional("source", this.source).propertyOptional("code", this.code).property("error", Strings.isEmpty((String)this.error) ? "error" : this.error).property("message", this.message).propertyOptional("details", this.details).endObject();
    }

    public void render(Request request, Response response) throws Throwable {
        response.setContentType("application/json;charset=UTF-8");
        this.toJson(response.getJsonWriter());
    }

    void response(Response response) {
        response.setContentType("application/json;charset=UTF-8");
        this.toJson(response.getJsonWriter());
    }

    public String toString() {
        return this.toJson();
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, Object> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }
}

