/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.Map;
import leap.lang.Args;
import leap.web.api.meta.model.MApiSecurityDef;

public class MOAuth2ApiSecurityDef
extends MApiSecurityDef {
    protected final String authzEndpointUrl;
    protected final String tokenEndpointUrl;
    protected final String flow;

    public MOAuth2ApiSecurityDef(String authzEndpointUrl, String tokenEndpointUrl) {
        this("oauth2", authzEndpointUrl, tokenEndpointUrl);
    }

    public MOAuth2ApiSecurityDef(String name, String authzEndpointUrl, String tokenEndpointUrl) {
        this(name, name, authzEndpointUrl, tokenEndpointUrl);
    }

    public MOAuth2ApiSecurityDef(String name, String title, String authzEndpointUrl, String tokenEndpointUrl) {
        this(name, title, authzEndpointUrl, tokenEndpointUrl, "implicit", null);
    }

    public MOAuth2ApiSecurityDef(String name, String title, String authzEndpointUrl, String tokenEndpointUrl, String flow, Map<String, Object> attrs) {
        super(name, title, attrs);
        Args.notEmpty((String)authzEndpointUrl, (String)"authorization endpoint url");
        Args.notEmpty((String)tokenEndpointUrl, (String)"token endpoint url");
        this.authzEndpointUrl = authzEndpointUrl;
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.flow = flow;
    }

    public String getAuthzEndpointUrl() {
        return this.authzEndpointUrl;
    }

    public String getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    @Override
    public boolean isOAuth2() {
        return true;
    }

    @Override
    public String getFlow() {
        return this.flow;
    }
}

