/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.ArrayList;
import java.util.List;
import leap.core.meta.MTypeManager;
import leap.lang.Builders;
import leap.lang.http.HTTP;
import leap.lang.meta.MType;
import leap.web.api.meta.model.MApiHeader;
import leap.web.api.meta.model.MApiHeaderBuilder;
import leap.web.api.meta.model.MApiObjectWithDescBuilder;
import leap.web.api.meta.model.MApiResponse;

public class MApiResponseBuilder
extends MApiObjectWithDescBuilder<MApiResponse> {
    protected MTypeManager typeManager;
    protected String name;
    protected Integer status;
    protected Class<?> typeClass;
    protected MType type;
    protected boolean file;
    protected List<MApiHeaderBuilder> headers = new ArrayList<MApiHeaderBuilder>();

    public static MApiResponseBuilder ok() {
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(HTTP.SC_OK);
        r.setSummary("Success");
        return r;
    }

    public static MApiResponseBuilder success(int status) {
        MApiResponseBuilder r = new MApiResponseBuilder();
        r.setStatus(status);
        r.setSummary("Success");
        return r;
    }

    public MApiResponseBuilder() {
    }

    public MApiResponseBuilder(MApiResponse r) {
        this.name = r.getName();
        this.status = r.getStatus();
        this.type = r.getType();
        this.file = r.isFile();
        this.setSummary(r.getSummary());
        this.setDescription(r.getDescription());
        for (MApiHeader header : r.getHeaders()) {
            this.headers.add(new MApiHeaderBuilder(header));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public void setTypeManager(MTypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public MType getType() {
        return this.type;
    }

    public void setType(MType type) {
        this.type = type;
    }

    public boolean isFile() {
        return this.file;
    }

    public void setFile(boolean file) {
        this.file = file;
    }

    public List<MApiHeaderBuilder> getHeaders() {
        return this.headers;
    }

    public void addHeader(MApiHeaderBuilder header) {
        this.headers.add(header);
    }

    public MApiResponse build() {
        if (this.name == null && this.status == null) {
            throw new IllegalStateException("'name' or 'status' must not be specified!");
        }
        if (null == this.name) {
            this.name = String.valueOf(this.status);
        }
        if (this.typeClass != null && this.type == null) {
            if (this.typeManager == null) {
                throw new IllegalStateException("'typeManager' must not be specified!");
            }
            this.type = this.typeManager.getMType(this.typeClass);
        }
        MApiHeader[] headerArray = (MApiHeader[])Builders.buildArray(this.headers, (Object[])new MApiHeader[this.headers.size()]);
        return new MApiResponse(this.name, this.summary, this.description, this.status, this.type, this.file, headerArray, this.attrs);
    }
}

