/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.List;
import java.util.Map;
import leap.lang.Args;
import leap.lang.exception.ObjectNotFoundException;
import leap.lang.http.HTTP;
import leap.web.api.meta.model.MApiObject;
import leap.web.api.meta.model.MApiOperation;

public class MApiPath
extends MApiObject {
    protected final String pathTemplate;
    protected final MApiOperation[] operations;

    public MApiPath(String pathTemplate, List<MApiOperation> operations, Map<String, Object> attrs) {
        super(attrs);
        Args.notEmpty((String)pathTemplate);
        this.pathTemplate = pathTemplate;
        this.operations = operations.toArray(new MApiOperation[0]);
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    public MApiOperation[] getOperations() {
        return this.operations;
    }

    public MApiOperation getOperation(HTTP.Method method) {
        for (MApiOperation op : this.operations) {
            if (!op.getMethod().equals((Object)method)) continue;
            return op;
        }
        throw new ObjectNotFoundException("No operation with method '" + method + "' exists!");
    }
}

