/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import leap.core.security.SimpleSecurity;
import leap.lang.Arrays2;
import leap.lang.Builders;
import leap.lang.http.HTTP;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiNamedWithDescBuilder;
import leap.web.api.meta.model.MApiOperation;
import leap.web.api.meta.model.MApiParameterBuilder;
import leap.web.api.meta.model.MApiResponseBuilder;
import leap.web.api.meta.model.MApiSecurityReq;
import leap.web.route.Route;

public class MApiOperationBuilder
extends MApiNamedWithDescBuilder<MApiOperation> {
    protected String id;
    protected Route route;
    protected HTTP.Method method;
    protected Set<String> tags = new LinkedHashSet<String>();
    protected List<MApiParameterBuilder> parameters = new ArrayList<MApiParameterBuilder>();
    protected List<MApiResponseBuilder> responses = new ArrayList<MApiResponseBuilder>();
    protected Set<String> consumes = new LinkedHashSet<String>();
    protected Set<String> produces = new LinkedHashSet<String>();
    protected Map<String, MApiSecurityReq> security = new HashMap<String, MApiSecurityReq>();
    protected MApiExtension extension;
    protected boolean allowAnonymous;
    protected boolean allowClientOnly;
    protected String[] permissions;
    protected SimpleSecurity[] securities;
    protected boolean deprecated;
    protected Boolean CorsEnabled;

    public MApiOperationBuilder() {
    }

    public MApiOperationBuilder(Route route) {
        this.route = route;
        MApiSecurityReq[] securities = (MApiSecurityReq[])route.getExtension(MApiSecurityReq[].class);
        if (null != securities) {
            for (MApiSecurityReq security : securities) {
                this.security.put(security.getName(), security);
            }
        } else {
            if (!this.security.containsKey("oauth2")) {
                MApiSecurityReq sec = new MApiSecurityReq("oauth2");
                this.security.put(sec.getName(), sec);
            }
            if (route.getPermissions() != null) {
                this.security.get("oauth2").addScopes(route.getPermissions());
            }
        }
        if (null != route.getAllowAnonymous()) {
            this.allowAnonymous = route.getAllowAnonymous();
        }
        if (null != route.getAllowClientOnly()) {
            this.allowClientOnly = route.getAllowClientOnly();
        }
        this.extension = (MApiExtension)((Object)route.getExtension(MApiExtension.class));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    public HTTP.Method getMethod() {
        return this.method;
    }

    public MApiOperationBuilder setMethod(HTTP.Method method) {
        this.method = method;
        return this;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public List<MApiParameterBuilder> getParameters() {
        return this.parameters;
    }

    public MApiParameterBuilder getParameter(String name) {
        for (MApiParameterBuilder p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public void addParameter(MApiParameterBuilder p) {
        this.parameters.add(p);
    }

    public List<MApiResponseBuilder> getResponses() {
        return this.responses;
    }

    public MApiResponseBuilder getResponse(String name) {
        for (MApiResponseBuilder r : this.responses) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public void addResponse(MApiResponseBuilder r) {
        this.responses.add(r);
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public void addConsume(String mimeType) {
        this.consumes.add(mimeType);
    }

    public Set<String> getProduces() {
        return this.produces;
    }

    public void addProduce(String mimeType) {
        this.produces.add(mimeType);
    }

    public Map<String, MApiSecurityReq> getSecurity() {
        return this.security;
    }

    public void setSecurity(Map<String, MApiSecurityReq> security) {
        this.security = security;
    }

    public void addSecurityRequirement(MApiSecurityReq req) {
        this.security.put(req.getName(), req);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    public boolean isAllowClientOnly() {
        return this.allowClientOnly;
    }

    public void setAllowClientOnly(boolean allowClientOnly) {
        this.allowClientOnly = allowClientOnly;
    }

    public String[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String[] permissions) {
        this.permissions = permissions;
    }

    public SimpleSecurity[] getSecurities() {
        return this.securities;
    }

    public void setSecurities(SimpleSecurity[] securities) {
        this.securities = securities;
    }

    public Boolean getCorsEnabled() {
        return this.CorsEnabled;
    }

    public void setCorsEnabled(Boolean corsEnabled) {
        this.CorsEnabled = corsEnabled;
    }

    public MApiExtension getExtension() {
        return this.extension;
    }

    public void setExtension(MApiExtension extension) {
        this.extension = extension;
    }

    public MApiOperation build() {
        return new MApiOperation(this.id, this.name, this.title, this.summary, this.description, this.method, this.route, this.tags.toArray(Arrays2.EMPTY_STRING_ARRAY), Builders.buildList(this.parameters), Builders.buildList(this.responses), this.consumes.toArray(Arrays2.EMPTY_STRING_ARRAY), this.produces.toArray(Arrays2.EMPTY_STRING_ARRAY), this.security.values().toArray(new MApiSecurityReq[this.security.size()]), this.allowAnonymous, this.allowClientOnly, this.deprecated, this.CorsEnabled, this.attrs, this.extension);
    }
}

