/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.List;
import java.util.Map;
import leap.lang.http.HTTP;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiNamedWithDesc;
import leap.web.api.meta.model.MApiParameter;
import leap.web.api.meta.model.MApiResponse;
import leap.web.api.meta.model.MApiSecurityReq;
import leap.web.route.Route;

public class MApiOperation
extends MApiNamedWithDesc {
    protected final String id;
    protected final Route route;
    protected final HTTP.Method method;
    protected final String[] tags;
    protected final MApiParameter[] parameters;
    protected final MApiResponse[] responses;
    protected final String[] consumes;
    protected final String[] produces;
    protected final MApiSecurityReq[] security;
    protected final boolean allowAnonymous;
    protected final boolean allowClientOnly;
    protected final boolean deprecated;
    protected final Boolean corsEnabled;
    protected final MApiExtension extension;

    public MApiOperation(String id, String name, String title, String summary, String description, HTTP.Method method, Route route, String[] tags, List<MApiParameter> parameters, List<MApiResponse> responses, String[] consumes, String[] produces, MApiSecurityReq[] security, boolean allowAnonymous, boolean allowClientOnly, boolean deprecated, Boolean cors, Map<String, Object> attrs, MApiExtension extension) {
        super(name, title, summary, description, attrs);
        this.id = id;
        this.route = route;
        this.method = method;
        this.tags = tags;
        this.parameters = parameters.toArray(new MApiParameter[0]);
        this.responses = responses.toArray(new MApiResponse[0]);
        this.consumes = consumes;
        this.produces = produces;
        this.security = security;
        this.allowAnonymous = allowAnonymous;
        this.allowClientOnly = allowClientOnly;
        this.deprecated = deprecated;
        this.corsEnabled = cors;
        this.extension = extension;
    }

    public String getId() {
        return this.id;
    }

    public Route getRoute() {
        return this.route;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public HTTP.Method getMethod() {
        return this.method;
    }

    public String[] getTags() {
        return this.tags;
    }

    public MApiParameter[] getParameters() {
        return this.parameters;
    }

    public MApiParameter tryGetParameter(String name) {
        for (MApiParameter p : this.parameters) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public MApiResponse[] getResponses() {
        return this.responses;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public MApiSecurityReq[] getSecurity() {
        return this.security;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public boolean isAllowClientOnly() {
        return this.allowClientOnly;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public Boolean getCorsEnabled() {
        return this.corsEnabled;
    }

    public MApiExtension getExtension() {
        return this.extension;
    }
}

