/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import leap.lang.Arrays2;
import leap.lang.Builders;
import leap.lang.Extensible;
import leap.lang.Strings;
import leap.lang.beans.BeanProperty;
import leap.lang.meta.MComplexType;
import leap.lang.meta.MComplexTypeBuilder;
import leap.lang.meta.MProperty;
import leap.web.api.annotation.ApiModel;
import leap.web.api.annotation.ApiProperty;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiModel;
import leap.web.api.meta.model.MApiNamedWithDescBuilder;
import leap.web.api.meta.model.MApiProperty;
import leap.web.api.meta.model.MApiPropertyBuilder;

public class MApiModelBuilder
extends MApiNamedWithDescBuilder<MApiModel>
implements Extensible {
    protected final Map<Class<?>, Object> extensions = new HashMap();
    protected String baseName;
    protected MComplexType type;
    protected boolean entity;
    protected MApiExtension extension;
    protected Set<Class<?>> javaTypes = new LinkedHashSet();
    protected Map<String, MApiPropertyBuilder> properties = new LinkedHashMap<String, MApiPropertyBuilder>();

    public MApiModelBuilder() {
    }

    public MApiModelBuilder(MComplexType type) {
        this(type, null);
    }

    public MApiModelBuilder(MComplexType type, String name) {
        this.type = type;
        this.name = Strings.isEmpty((String)name) ? type.getName() : name;
        this.title = type.getTitle();
        this.summary = type.getSummary();
        this.description = type.getDescription();
        this.entity = type.isEntity();
        boolean annotatedOnly = false;
        if (null != type.getJavaType()) {
            this.javaTypes.add(type.getJavaType());
            ApiModel a = type.getJavaType().getAnnotation(ApiModel.class);
            if (null != a) {
                this.name = Strings.firstNotEmpty((String[])new String[]{a.name(), a.value(), this.name});
                this.description = Strings.firstNotEmpty((String[])new String[]{a.desc(), this.description});
                annotatedOnly = a.explicitProperties();
            }
        }
        for (MProperty mp : type.getProperties()) {
            BeanProperty bp;
            if (annotatedOnly && null != (bp = mp.getBeanProperty()) && !bp.isAnnotationPresent(ApiProperty.class)) continue;
            this.addProperty(new MApiPropertyBuilder(mp));
        }
    }

    public MComplexTypeBuilder toMComplexType() {
        MComplexTypeBuilder ct = new MComplexTypeBuilder();
        ct.setName(this.name);
        ct.setTitle(this.title);
        ct.setSummary(this.summary);
        ct.setDescription(this.description);
        ct.setEntity(this.entity);
        for (MApiPropertyBuilder p : this.properties.values()) {
            ct.addProperty(p.toMProperty());
        }
        return ct;
    }

    public boolean isEntity() {
        return this.entity;
    }

    public void setEntity(boolean entity) {
        this.entity = entity;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public Set<Class<?>> getJavaTypes() {
        return this.javaTypes;
    }

    public void addJavaType(Class<?> c) {
        this.javaTypes.add(c);
        if (this.javaTypes.size() > 1) {
            Class c2;
            Class c1;
            Class[] types = this.javaTypes.toArray(new Class[0]);
            if (types.length == 2 && ((c1 = types[0]).isAssignableFrom(c2 = types[1]) || c2.isAssignableFrom(c1))) {
                return;
            }
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(types[i].getName());
            }
            throw new IllegalStateException("Duplicated api model '" + this.name + "' at [" + s.toString() + "]");
        }
    }

    public Map<String, MApiPropertyBuilder> getProperties() {
        return this.properties;
    }

    public MApiPropertyBuilder getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(MApiPropertyBuilder p) {
        this.properties.put(p.getName(), p);
    }

    public MApiPropertyBuilder removeProperty(String name) {
        return this.properties.remove(name);
    }

    public MApiExtension getExtension() {
        return this.extension;
    }

    public void setExtension(MApiExtension extension) {
        this.extension = extension;
    }

    public Map<Class<?>, Object> getExtensions() {
        return this.extensions;
    }

    public final <T> T getExtension(Class<?> type) {
        return (T)this.extensions.get(type);
    }

    public final <T> void setExtension(Class<T> type, Object extension) {
        this.extensions.put(type, extension);
    }

    public <T> T removeExtension(Class<?> type) {
        return (T)this.extensions.remove(type);
    }

    public MApiModel build() {
        MApiModel m = new MApiModel(this.entity, this.baseName, this.name, this.title, this.summary, this.description, this.javaTypes.toArray(Arrays2.EMPTY_CLASS_ARRAY), (MApiProperty[])Builders.buildArray(this.properties.values(), (Object[])new MApiProperty[this.properties.size()]), this.attrs, this.extension);
        m.getExtensions().putAll(this.extensions);
        return m;
    }
}

