/*
 * Decompiled with CFR 0.152.
 */
package leap.web.api.meta.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.Extensible;
import leap.lang.Strings;
import leap.web.api.meta.model.MApiExtension;
import leap.web.api.meta.model.MApiNamedWithDesc;
import leap.web.api.meta.model.MApiProperty;

public class MApiModel
extends MApiNamedWithDesc
implements Extensible {
    protected final Map<Class<?>, Object> extensions = new ConcurrentHashMap();
    protected final boolean entity;
    protected final String baseName;
    protected final Class<?>[] javaTypes;
    protected final MApiProperty[] properties;
    protected final MApiExtension extension;

    public MApiModel(boolean entity, String baseName, String name, String title, String summary, String description, Class<?>[] javaTypes, MApiProperty[] properties, Map<String, Object> attrs, MApiExtension extension) {
        super(name, title, summary, description, attrs);
        this.entity = entity;
        this.baseName = baseName;
        this.javaTypes = javaTypes;
        this.properties = properties;
        this.extension = extension;
    }

    public boolean isEntity() {
        return this.entity;
    }

    public boolean hasBaseModel() {
        return !Strings.isEmpty((String)this.baseName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Class<?>[] getJavaTypes() {
        return this.javaTypes;
    }

    public MApiProperty[] getProperties() {
        return this.properties;
    }

    public MApiProperty tryGetProperty(String name) {
        return this.tryGetProperty(name, false);
    }

    public MApiProperty tryGetProperty(String name, boolean ignoreCause) {
        for (MApiProperty p : this.properties) {
            if (!(ignoreCause ? p.getName().equalsIgnoreCase(name) : p.getName().equals(name))) continue;
            return p;
        }
        return null;
    }

    public MApiExtension getExtension() {
        return this.extension;
    }

    public Map<Class<?>, Object> getExtensions() {
        return this.extensions;
    }

    public final <T> T getExtension(Class<?> type) {
        return (T)this.extensions.get(type);
    }

    public final <T> void setExtension(Class<T> type, Object extension) {
        this.extensions.put(type, extension);
    }

    public <T> T removeExtension(Class<?> type) {
        return (T)this.extensions.remove(type);
    }
}

